/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.normal;

import com.bokesoft.yes.data.service.DocumentServiceManager;
import com.bokesoft.yes.data.service.IDocumentService;
import com.bokesoft.yes.excel.cmd.normal.ExcelStyleFactory;
import com.bokesoft.yes.excel.cmd.normal.IExport;
import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelRow;
import com.bokesoft.yes.excel.template.ExcelSheet;
import com.bokesoft.yes.excel.template.ExcelWorkbook;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.transformer.ExcelTransformerFactory;
import com.bokesoft.yes.excel.transformer.IExcelTransformer;
import com.bokesoft.yes.excel.utils.ExcelFileUtil;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.ve.VE;
import com.bokesoft.yigo.util.ExcelUtils;
import com.bokesoft.yigo.util.StampExcelUtil;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BatchExportExcelWithTemplate
implements IExport {
    private DefaultContext context = null;
    private DataTable srcDataTable = null;
    private String OIDFieldKey = null;
    private Workbook workbook = null;
    private MetaExcelWorkbook metaWorkbook = null;
    private ExcelWorkbook virtualWorkbook = null;
    private MetaForm metaForm = null;
    private MetaDataObject exportMetaDataObject = null;
    private ExcelTransformerFactory transformerFactory = null;
    private ExcelStyleFactory styleFactory = null;
    private String postServiceName = null;
    private String exportFileName = null;
    private HashMap<String, Integer> sheetRowIndex = new HashMap();
    private HashMap<String, HashMap<Integer, Integer>> sheetColumnWidths = new HashMap();
    private boolean needDownload = false;

    public BatchExportExcelWithTemplate(DefaultContext defaultContext, MetaExcelWorkbook metaExcelWorkbook, DataTable dataTable, String string, String string2, String string3, String string4, boolean bl) throws Throwable {
        this.context = defaultContext;
        this.metaWorkbook = metaExcelWorkbook;
        this.postServiceName = string3;
        this.srcDataTable = dataTable;
        this.OIDFieldKey = string;
        this.exportFileName = string4;
        this.needDownload = bl;
        this.metaForm = defaultContext.getVE().getMetaFactory().getMetaForm(string2);
        this.exportMetaDataObject = this.metaForm.getDataSource().getDataObject();
    }

    @Override
    public FileData exportData() throws Throwable {
        this.virtualWorkbook = new ExcelWorkbook(this.exportMetaDataObject, this.metaWorkbook, this.context.getMidParser());
        this.virtualWorkbook.calcExpandColumn(this.context.getMidParser(), null, this.exportMetaDataObject);
        this.workbook = new SXSSFWorkbook(500);
        this.transformerFactory = new ExcelTransformerFactory();
        this.styleFactory = new ExcelStyleFactory(this.workbook);
        boolean bl = true;
        Object object = null;
        DefaultContext defaultContext = ExcelUtils.getOIDs(this.srcDataTable, this.OIDFieldKey);
        IDocumentService iDocumentService = DocumentServiceManager.getInstance().getDocumentService(this.context, "Excel", "BatchExportExcelWithTemplate", this.metaForm.getKey(), this.metaWorkbook.getKey());
        iDocumentService.init(this.context, this.metaForm.getKey(), defaultContext, true);
        while (iDocumentService.hasNext()) {
            object = (Document)iDocumentService.next();
            if (object == null) continue;
            defaultContext = new DefaultContext(this.context);
            defaultContext.setDocument((Document)object);
            this.exportSingleDocument(defaultContext, bl, (Document)object);
            bl = false;
        }
        String string = ExcelUtils.getExportFilePath(this.context.getVE().getMetaFactory(), this.metaWorkbook.getFormKey());
        new FileData();
        this.context.setDocument((Document)object);
        string = !this.needDownload ? ExcelFileUtil.writeExcel(this.workbook, string) : ExcelFileUtil.convertWorkbookToFileData(this.metaWorkbook.getFormKey(), this.exportFileName, this.workbook);
        object = ExcelUtils.getPostExtProcess(this.context, this.postServiceName);
        if (object != null) {
            object.process(this.context, (FileData)string);
        }
        if (this.needDownload) {
            return string;
        }
        return new FileData();
    }

    private void exportSingleDocument(DefaultContext defaultContext, boolean bl, Document document) throws Throwable {
        Iterator<ExcelSheet> iterator = this.virtualWorkbook.iterator();
        while (iterator.hasNext()) {
            ExcelSheet excelSheet = iterator.next();
            Object object = excelSheet.getName();
            Sheet sheet = ExcelUtil.getSheet((Workbook)this.workbook, (String)object);
            if (!this.sheetColumnWidths.containsKey(object)) {
                this.sheetColumnWidths.put((String)object, new HashMap());
            }
            if (!this.sheetRowIndex.containsKey(object)) {
                this.sheetRowIndex.put((String)object, 0);
            }
            int n = this.sheetRowIndex.get(object);
            HashMap<Integer, Integer> hashMap = this.sheetColumnWidths.get(excelSheet.getName());
            Iterator<ExcelRow> iterator2 = excelSheet.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                switch (((ExcelRow)object).getType()) {
                    case 1: 
                    case 2: 
                    case 5: {
                        if (!bl) break;
                        this.exportFixRow(document, sheet, (ExcelRow)object, n, hashMap);
                        break;
                    }
                    case 3: {
                        n = this.exportDetailRow(defaultContext, document, sheet, (ExcelRow)object, n, hashMap);
                    }
                }
            }
            this.sheetRowIndex.put(excelSheet.getName(), n);
        }
    }

    private int exportDetailRow(DefaultContext defaultContext, Document document, Sheet sheet, ExcelRow excelRow, int n, HashMap<Integer, Integer> object) throws Throwable {
        object = excelRow.getTableKey();
        if ((object = document.get((String)object)) == null) {
            return n;
        }
        int n2 = excelRow.getRowIndex() - 1;
        object.beforeFirst();
        while (object.next(true)) {
            int n3 = n2 + n;
            Row row = ExcelUtil.getRow((Sheet)sheet, (int)n3);
            row.setHeightInPoints((float)((short)excelRow.getHeight()));
            this.fillDetailData(defaultContext, row, document, excelRow);
            ++n;
        }
        return n;
    }

    private void fillDetailData(DefaultContext defaultContext, Row row, Document document, ExcelRow object) throws Throwable {
        Object object2 = ((ExcelRow)object).getTableKey();
        DataTable dataTable = document.get((String)object2);
        object = ((ExcelRow)object).iterator();
        while (object.hasNext()) {
            object2 = (ExcelCell)object.next();
            String string = ((ExcelCell)object2).getDefinition();
            Object object3 = ((ExcelCell)object2).getSourceType();
            int n = ((ExcelCell)object2).getCellIndex() - 1;
            Cell cell = ExcelUtil.getCell((Row)row, (int)n);
            Object object4 = null;
            if (((String)object3).equalsIgnoreCase("field")) {
                object3 = ((ExcelCell)object2).getTableKey();
                if (object3 == null || ((String)object3).isEmpty()) {
                    object4 = dataTable.getObject(string);
                } else {
                    MetaTable metaTable = this.exportMetaDataObject.getTable((String)object3);
                    object3 = document.get((String)object3);
                    if (metaTable.getTableMode() == 0) {
                        object3.first();
                    }
                    object4 = object3.getObject(string);
                }
            } else if (((String)object3).equalsIgnoreCase("const")) {
                object4 = string;
            } else if (((String)object3).equalsIgnoreCase("formula")) {
                object4 = defaultContext.getMidParser().eval(0, string);
            }
            object3 = this.styleFactory.getCellStyle((ExcelCell)object2);
            cell.setCellStyle((CellStyle)object3);
            short s = StampExcelUtil.getExcelCellStyle((ExcelCell)object2, this.workbook);
            if (s != -1) {
                object3.setDataFormat(s);
            } else {
                object3 = this.transformerFactory.getTransformer((VE)defaultContext.getVE(), (ExcelCell)object2);
                if (object3 != null) {
                    object4 = object3.transform((ExcelCell)object2, object4);
                }
            }
            if (StampExcelUtil.isNumericCell((ExcelCell)object2)) {
                cell.setCellType(CellType.NUMERIC);
            }
            if (object4 == null) continue;
            ExcelUtil.setCellValue((Cell)cell, (Object)object4);
        }
    }

    private void exportFixRow(Document document, Sheet sheet, ExcelRow excelRow, int n, HashMap<Integer, Integer> row) throws Throwable {
        n = excelRow.getRowIndex() - 1 + n;
        row = ExcelUtil.getRow((Sheet)sheet, (int)n);
        row.setHeightInPoints((float)((short)excelRow.getHeight()));
        Object object = null;
        Iterator<ExcelCell> iterator = excelRow.iterator();
        while (iterator.hasNext()) {
            ExcelCell excelCell = iterator.next();
            int n2 = excelCell.getCellIndex() - 1;
            int n3 = excelCell.getMergedColumnSpan() - 1;
            int n4 = excelCell.getMergedRowSpan() - 1;
            String string = excelCell.getDefinition();
            excelRow = ExcelUtil.getCell((Row)row, (int)n2);
            String string2 = excelCell.getSourceType();
            if (string2.equalsIgnoreCase("field")) {
                if (excelCell.getColumnExpandTarget()) {
                    object = excelCell.getExpandCaption();
                } else {
                    object = excelCell.getTableKey();
                    object = document.get((String)object).getObject(string);
                }
            } else if (string2.equalsIgnoreCase("const")) {
                object = string;
            } else if (string2.equalsIgnoreCase("formula")) {
                object = this.context.getMidParser().eval(0, string);
            }
            string = this.styleFactory.getCellStyle(excelCell);
            if (n3 > 0 || n4 > 0) {
                for (int i = 0; i <= n3; ++i) {
                    for (int j = 0; j <= n4; ++j) {
                        excelRow = ExcelUtil.getCell((Sheet)sheet, (int)(n + j), (int)(n2 + i));
                        excelRow.setCellStyle((CellStyle)string);
                    }
                }
                int n5 = n;
                int n6 = n2;
                sheet.addMergedRegionUnsafe(new CellRangeAddress(n5, n5 + n4, n6, n6 + n3));
            } else {
                excelRow.setCellStyle((CellStyle)string);
            }
            short s = StampExcelUtil.getExcelCellStyle(excelCell, this.workbook);
            if (s != -1) {
                string.setDataFormat(s);
            } else {
                IExcelTransformer iExcelTransformer = this.transformerFactory.getTransformer((VE)this.context.getVE(), excelCell);
                if (iExcelTransformer != null) {
                    object = iExcelTransformer.transform(excelCell, object);
                }
            }
            if (StampExcelUtil.isNumericCell(excelCell)) {
                excelRow.setCellType(CellType.NUMERIC);
            }
            if (object == null) continue;
            ExcelUtil.setCellValue((Cell)excelRow, (Object)object);
        }
    }
}

