package com.bokesoft.yes.mid.function;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.parser.BaseMidFunctionImpl;
import com.bokesoft.yigo.mid.util.MidI18NUtil;
import com.bokesoft.yigo.parser.BaseFunImplCluster;
import com.bokesoft.yigo.parser.IExecutor;
import com.bokesoft.yigo.tools.ve.VE;

public class MidMiscFunction extends BaseFunImplCluster {

	/**
	 * 通过组和标识取得本地化字符串，参数列表为[group, key]
	 * <ul>
	 * <li>group 组标识
	 * <li>key 字符串标识
	 * </ul>
	 * <p>返回相应语种的字符串定义</p>
	 * @author wangyh
	 *
	 */
	class LocaleStringImpl extends BaseMidFunctionImpl {

		@Override
		public Object evalImpl(String name, DefaultContext context, Object[] args, IExecutor executor) throws Throwable {
			String group = "", key = "";
			if (args.length == 1) {
				key = (String) args[0];
			} else if (args.length == 2) {
				group = (String) args[0];
				key = (String) args[1];
			}
			if (!key.startsWith("String")) {
				key = "String" + key;
			}
			if (group.isEmpty()) {
				group = "Strings";
			}
			VE ve = context.getVE();
			String text = MidI18NUtil.getLocaleString(ve, group, key);
			if (text == null) {
				throw new MetaException(MetaException.LOCALE_STRING_UNDEFINED,
						SimpleStringFormat.format(StringTable.getString(null, "", StringTable.LocaleStringUndefined), group, key));
			}
			return text;
		}
	}
	
	/**
	 * 通过组和标识取得本地化带参数字符串，参数列表为[group, key, paras]
	 * <ul>
	 * <li>group 组标识
	 * <li>key 字符串标识
	 * <li>paras 参数集
	 * </ul>
	 * <p>返回相应语种的字符串定义</p>
	 *
	 */
	class LocaleParaFormatImpl extends BaseMidFunctionImpl {

		@Override
		public Object evalImpl(String name, DefaultContext context, Object[] args, IExecutor executor)
				throws Throwable {
			String group = "", key = "";
			if (args.length == 1) {
				key = (String) args[0];
			} else if (args.length == 2) {
				group = (String) args[0];
				key = (String) args[1];
			}
			if (!key.startsWith("String")) {
				key = "String" + key;
			}
			if (group.isEmpty()) {
				group = "Strings";
			}
			VE ve = context.getVE();
			String format = MidI18NUtil.getLocaleString(ve, group, key);
			if (format == null) {
				throw new MetaException(MetaException.LOCALE_STRING_UNDEFINED,
						SimpleStringFormat.format(StringTable.getString(context.getEnv(), "", StringTable.LocaleStringUndefined), group, key));
			}
			return SimpleStringFormat.format(format, args, 2);
		}
	}
	
	
	@Override
	public Object[][] getImplTable() {
		return new Object[][] {
				{ "LocaleString", new LocaleStringImpl() },
				{ "LocaleParaFormat","LocaleFormat", new LocaleParaFormatImpl() }
		};
	}

}
