package com.bokesoft.yes.mid.function;

import java.util.ArrayList;
import java.util.HashMap;

import com.bokesoft.yes.common.encrypt.SaltHash;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.EncryptType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.setting.MetaLoginSetting;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.para.SysPara;
import com.bokesoft.yigo.mid.parser.BaseMidFunctionImpl;
import com.bokesoft.yigo.mid.rsa.RSAMidUtil;
import com.bokesoft.yigo.parser.BaseFunImplCluster;
import com.bokesoft.yigo.parser.IExecutor;
import com.bokesoft.yigo.struct.condition.ConditionItem;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.dict.ItemData;
import com.bokesoft.yigo.struct.env.Env;
import com.bokesoft.yigo.struct.usrpara.Paras;

public class MidUtilFunction extends BaseFunImplCluster {
	class EncryptPasswordImpl extends BaseMidFunctionImpl {

		@Override
		public Object evalImpl(String name, DefaultContext context,
				Object[] args, IExecutor executor) throws Throwable {
			String s = TypeConvertor.toString(args[0]);
			
			//加盐哈希
			MetaSetting setting = context.getVE().getMetaFactory().getSetting();
			if (setting != null ) {
				MetaLoginSetting loginSetting = setting.getLogin();
				if (loginSetting != null && loginSetting.getEncryptType() == EncryptType.HASH) {
					return SaltHash.createHash(s);
				}
			}
			
			//非对称加密
			String publicKey = SysPara.getInstance().get("PublicKey");
			String password = RSAMidUtil.encryptByPublic(publicKey, s);
			return password;
		}
		
	}
	
	/**
	 * 设置参数，参数列表为[key, value]
	 * <ul>
	 * <li>key 参数名称
	 * <li>value 参数值
	 * </ul>
	 * @author wangyh
	 *
	 */
	class SetParaImpl extends BaseMidFunctionImpl {

		@Override
		public Object evalImpl(String name, DefaultContext context,
				Object[] args, IExecutor executor) throws Throwable {
			String key = (String)args[0];
			Object value = args[1];
			Paras paras = context.ensureParas();
			paras.put(key, value);
			return true;
		}
		
	}
	
	/**
	 * 取得参数值，参数列表为[key]
	 * <ul>
	 * <li>key 参数标识
	 * </ul>
	 * <p>返回值：如果key存在则返回其值，否则返回null
	 * </p>
	 * @author wangyh
	 *
	 */
	class GetParaImpl extends BaseMidFunctionImpl {

		@Override
		public Object evalImpl(String name, DefaultContext context,
				Object[] args, IExecutor executor) throws Throwable {
			String key = (String)args[0];
			return context.getPara(key);
		}
		
	}
	
	/**
	 * 取得会话级参数，参数列表为[key]
	 * <ul>
	 * <li>key 会话级参数标识
	 * </ul>
	 * <p>返回值：如果存在key指定的会话级参数则返回其值，否则返回null</p>
	 * @author wangyh
	 *
	 */
	class GetSessionParaImpl extends BaseMidFunctionImpl {

		@Override
		public Object evalImpl(String name, DefaultContext context,
				Object[] args, IExecutor executor) throws Throwable {
			Env env = context.getEnv();
			String key = (String)args[0];
			return env.get(key);
		}
		
	}
	
	/**
	 * ConditionPara取得查询条件中的值，参数列表为[key]
	 * <ul>
	 * <li>key 查询条件标识
	 * </ul>
	 * 返回值：如果key存在返回其值，否则返回null
	 * @author wangyh
	 *
	 */
	class ConditionParaImpl extends BaseMidFunctionImpl {

		@Override
		public Object evalImpl(String name, DefaultContext context, Object[] args, IExecutor executor)
				throws Throwable {
			String key = (String)args[0];
			Object value = null;
			ConditionParas paras = context.getConditionParas();
			if ( paras != null ) {
				for ( int i = 0, size = paras.size(); i<size; ++i ) {
					ConditionItem p = paras.get(i);
					if ( key.equals(p.getKey()) ) {
						if (p.getItemKey() != "") {
							value = p.getValue();
							if(value instanceof ItemData) {
								ItemData itemData = (ItemData) p.getValue();
								if (itemData.getOID() == -1 || !itemData.getEditValue().equals("")) {
									value = itemData.getEditValue();
								}else {
									value = itemData.getOID();
								}
							}else if(value instanceof ArrayList) {
								//处理多选字典的情况
								value = p.getValue();
								ArrayList<?> valueList = (ArrayList<?>)value;
								String valueStr = "";
								for (int j = 0; j < valueList.size(); j++) {
									if (valueList.get(j) instanceof ItemData) {
										ItemData itemData = (ItemData) valueList.get(j);
										Object str= "";
										if (itemData.getOID() == -1 || !itemData.getEditValue().equals("")) {
											str = itemData.getEditValue();
										}else {
											str = itemData.getOID();
										}
										valueStr += "," + str.toString();
									} else {
										valueStr += "," + valueList.get(j);
									}
								}
								value = valueStr.substring(1);
							}
						} else {
							value = p.getValue();
						}
						break;
					}
				}
			}
			return value;
		}
		
	}
	
	/**
	 * NewHashMap根据数据生成HashMap，参数形式可能变
	 * <ul>
	 * <li>[table, keyColumn, valueColumn]，当第一个参数为DataTable时，参数形式如下：
	 * <ul>
	 * <li>table DataTable数据表
	 * <li>keyColumn HashMap的关键字列标识
	 * <li>valueColumn HashMap的值列标识
	 * </ul>
	 * <li>[string, keyType, valueType]
	 * <ul>
	 * <li>string 为字面量表示的名－值对，字符串的形式为
	 * <pre>
	 * key1:value1,key2:value2
	 * </pre>
	 * <li>keyType HashMap的关键字列类型
	 * <li>valueType HashMap的值列类型
	 * </ul>
	 * </ul>
	 * 返回值:HashMap<Object, Object>
	 * @author wangyh
	 *
	 */
	class NewHashMapImpl extends BaseMidFunctionImpl {

		@Override
		public Object evalImpl(String name, DefaultContext context, Object[] args, IExecutor executor)
				throws Throwable {
			HashMap<Object, Object> map = new HashMap<Object, Object>();
			Object source = args[0];
			if ( source instanceof String ) { 
				int keyType = DataType.parse((String)args[1]);
				int valueType = DataType.parse((String)args[2]);
				String[] v = ((String)source).split(",");
				for ( int i = 0, size = v.length; i<size; ++i ) {
					String tmp = v[i];
					int index = tmp.indexOf(':');
					String keyS = tmp.substring(0, index);
					String valueS = tmp.substring(index + 1);
					map.put(transString(keyS, keyType), transString(valueS, valueType));
				}
			} else if ( source instanceof DataTable ) {
				
			}
			return map;
		}
		
		private Object transString(String s, int type) {
			Object r = null;
			switch ( type ) {
			case DataType.LONG:
				r = TypeConvertor.toLong(s);
				break;
			case DataType.INT:
				r = TypeConvertor.toInteger(s);
				break;
			case DataType.NUMERIC:
				r = TypeConvertor.toBigDecimal(s);
				break;
			}
			return r;
		}
	}
	
	@Override
	public Object[][] getImplTable() {
		return new Object[][] {
				{ "EncryptPassword", new EncryptPasswordImpl() },
				{ "GetPara", "Para", new GetParaImpl() },
				{ "SetPara", new SetParaImpl() },
				{ "GetSessionPara", "SessionPara", new GetSessionParaImpl() },
				{ "ConditionPara", new ConditionParaImpl() }
		};
	}

}
