package com.bokesoft.yes.mid.function;

import java.util.ArrayList;
import java.util.List;

import com.bokesoft.yigo.mid.base.BaseContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.parser.BaseGeneralMidFunctionImpl;
import com.bokesoft.yigo.mid.query.DBNamedQuery;
import com.bokesoft.yigo.mid.query.DBNamedUpdate;
import com.bokesoft.yigo.parser.BaseFunImplCluster;
import com.bokesoft.yigo.parser.IExecutor;
import com.bokesoft.yigo.struct.datatable.DataTable;

public class MidQueryFunction extends BaseFunImplCluster {
	
	/**
	 * 根据Key查找相应的SQL执行 参数列表为[Key,args1,args2...]
	 * <ul>
	 * <li>Key，预定义的查询的标识
	 * <li>args1,2... 问号参数集
	 * </ul>
	 * 返回值：DataTable数据集
	 * @author wangyh
	 *
	 */
	class DBNamedQueryImpl extends BaseGeneralMidFunctionImpl {

		@Override
		public Object evalImpl(String name, BaseContext context, Object[] args, IExecutor executor) throws Throwable {
			String sqlName = args[0].toString();
			//值
			List<Object> list = new ArrayList<Object>();
			
			for( int i = 1;i < args.length;i++ ){
				list.add(args[i]);
			}
			String formKey = context.getFormKey();
			
			DBNamedQuery query = new DBNamedQuery(context, formKey, sqlName, list);
			return query.exec();
		}
		
	}
	
	/**
	 * 根据命名的更新语句更新数据，参数列表为[name, args...]
	 * <ul>
	 * <li>name 更新语句的名称
	 * <li>args 不定长参数为更新语中的?参数值
	 * </ul>
	 * 返回值：受影响的数据行数
	 * @author wangyh
	 *
	 */
	class DBNamedUpdateImpl extends BaseGeneralMidFunctionImpl {

		@Override
		public Object evalImpl(String name, BaseContext context, Object[] args, IExecutor executor) throws Throwable {
			String sqlName = (String)args[0];
			List<Object> list = new ArrayList<Object>();
			for (int i = 1; i < args.length; i++) {
				list.add(args[i]);
			}
			String formKey = context.getFormKey();
			DBNamedUpdate update = new DBNamedUpdate(context, formKey, sqlName, list);
			return update.exec();
		}
		
	}
	
	/**
	 * 返回查询表的第一行第一列的值,参数列表为[Key,arg1,arg2...]
	 * <ul>
	 * <li>Key 预定义查询语句的标识
	 * <li>args1,2... 查询语句中问号参数的值
	 * </ul>
	 * 返回值：返回结果中第0行，第0列的值，如果不存在行，那么返回null
	 * @author wangyh
	 *
	 */
	class DBNamedQueryValueImpl extends BaseGeneralMidFunctionImpl {

		@Override
		public Object evalImpl(String name, BaseContext context, Object[] args, IExecutor executor) throws Throwable {
			String sqlName = args[0].toString();
			//值
			List<Object> list = new ArrayList<Object>();
			
			for( int i = 1;i < args.length;i++ ){
				list.add(args[i]);
			}
			String formKey = context.getFormKey();
			
			DBNamedQuery query = new DBNamedQuery(context, formKey, sqlName, list);
			DataTable table = query.exec();
			Object result = null;
			if (table.first()) {
				result = table.getObject(0, 0);
			}
			return result;
		}
		
	}
	
	/**
	 * 数据查询 参数列表为：[SQL,args...] 第一位参数为SQL语句,后面为参数列表， 依次与SQL中？对应 
	 * <ul>
	 * <li>SQL，查询语句
	 * <li>args1,2,...　SQL中问号参数的值
	 * </ul>
	 * 返回值：DataTable数据集
	 * @author wangyh
	 *
	 */
	class DBQueryImpl extends BaseGeneralMidFunctionImpl {

		@Override
		public Object evalImpl(String name, BaseContext context, Object[] args, IExecutor executor) throws Throwable {
			String SQL = args[0].toString();
			//值
			List<Object> list = new ArrayList<Object>();
			
			for (int i = 1; i < args.length; i++) {
				list.add(args[i]);
			}

			IDBManager dbManager = context.getDBManager();
			DataTable table = dbManager.execPrepareQuery(SQL, list);
			return table;
		}
		
	}
	
	/**
	 * 更新数据 参数列表为：[SQL,args...] 第一位参数为SQL语句,后面为参数列表， 依次与SQL中？对应
	 * <ul>
	 * <li>SQL 更新语句
	 * <li>args1,2... SQL中问号参数的值
	 * </ul>
	 * 返回值：更新语句受影响的行数
	 * @author wangyh
	 *
	 */
	class DBUpdateImpl extends BaseGeneralMidFunctionImpl {

		@Override
		public Object evalImpl(String name, BaseContext context, Object[] args, IExecutor executor) throws Throwable {
			String SQL = args[0].toString();

			List<Object> list = new ArrayList<Object>();
			for (int i = 1; i < args.length; i++) {
				list.add(args[i]);
			}
			IDBManager dbManager = context.getDBManager();
			int count = dbManager.execPrepareUpdate(SQL, list);
			return count;
		}
		
	}
	
	/**
	 * 返回查询结果第一行第一列值 如DBQueryValue(); 参数列表为[SQL,args1,args2...]
	 * <ul>
	 * <li>SQL 查询语句
	 * <li>args1,2... SQL中问号参数的值
	 * </ul>
	 * 返回值：返回值中第0行，第0列的值，如果不存在行，则返回null
	 * @author wangyh
	 *
	 */
	class DBQueryValueImpl extends BaseGeneralMidFunctionImpl {

		@Override
		public Object evalImpl(String name, BaseContext context, Object[] args, IExecutor executor) throws Throwable {
			String SQL = args[0].toString();
			//值
			List<Object> list = new ArrayList<Object>();
			
			for (int i = 1; i < args.length; i++) {
				list.add(args[i]);
			}

			IDBManager dbManager = context.getDBManager();
			DataTable table = dbManager.execPrepareQuery(SQL, list);
			Object result = null;
			if ( table.first() ) {
				result = table.getObject(0, 0);
			}
			return result;
		}
		
	}
	
	@Override
	public Object[][] getImplTable() {
		return new Object[][] {
			{ "DBNamedQuery", new DBNamedQueryImpl() },
			{ "DBNamedUpdate", new DBNamedUpdateImpl() },
			{ "DBNamedQueryValue", new DBNamedQueryValueImpl() },
			{ "DBQuery", new DBQueryImpl() },
			{ "DBUpdate", new DBUpdateImpl() },
			{ "DBQueryValue", new DBQueryValueImpl() }
		};
	}

}
