package com.bokesoft.yes.mid.function;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.tools.dic.DictCacheUtil;
import com.bokesoft.yigo.common.def.DataObjectSecondaryType;
import com.bokesoft.yigo.common.def.DictStateMask;
import com.bokesoft.yigo.common.def.OperationState;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.parser.BaseMidFunctionImpl;
import com.bokesoft.yigo.parser.BaseFunImplCluster;
import com.bokesoft.yigo.parser.IExecutor;
import com.bokesoft.yigo.struct.dict.Item;
import com.bokesoft.yigo.tools.ve.VE;

public class MidDictFunction extends BaseFunImplCluster {
	public MidDictFunction() {
		super();
	}

	/**
	 * 获取字典相关属性的值
	 * <ul>
	 * <li>ItemKey 字典标识
	 * <li>OID 字典数据对象的数据标识
	 * <li>FieldKey 数据字段的标识，形式为[表名.列名]
	 * </ul>
	 * <p>返回值为字典项的属性值。
	 * </p>
	 * @author 王元和
	 *
	 */
	class GetDictValueImpl extends BaseMidFunctionImpl {

		@Override
		public Object evalImpl(String name, DefaultContext context,
				Object[] args, IExecutor executor) throws Throwable {
			String itemKey = TypeConvertor.toString(args[0]);
			long oid = TypeConvertor.toLong(args[1]);
			
			Object value = null;
			if(itemKey != null && !itemKey.isEmpty() && oid > 0){
				String fieldKey = TypeConvertor.toString(args[2]);
				VE ve = context.getVE();
				value = DictCacheUtil.getDictValue(ve, context.getDictCache(), itemKey, oid, fieldKey);
			}

			return value;
		}
	}
	
	/**
	 * 获取字段值查找字典OID，查找内容需唯一
	 * <ul>
	 * <li>ItemKey 字典标识
	 * <li>FieldKey 字段标识
	 * <li>Value 值
	 * </ul>
	 * <p>返回值为字典项的OID。
	 * </p>
	 */
	class GetDictOIDImpl extends BaseMidFunctionImpl {

		@Override
		public Object evalImpl(String name, DefaultContext context,
				Object[] args, IExecutor executor) throws Throwable {
			String itemKey = TypeConvertor.toString(args[0]);
			String columnKey = TypeConvertor.toString(args[1]);
			Object value = args[2];

			IMetaFactory metaFactory = context.getVE().getMetaFactory();
			MetaDataObject metaDataObject = metaFactory.getDataObject(itemKey);
			
			if(metaDataObject == null){
				throw new MetaException(MetaException.NO_DATAOBJECT_DEFINED, 
						SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoDataObjectDefined), itemKey));
			}
			
			if(metaDataObject.getSecondaryType() != DataObjectSecondaryType.DICT && metaDataObject.getSecondaryType() != DataObjectSecondaryType.CHAINDICT){
				throw new MetaException(MetaException.NO_DATAOBJECT_DEFINED, 
						SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoDataObjectDefined), itemKey));
			}
			
			
			
			long oid = 0;

			Item item = context.getDictCache().locate(itemKey, columnKey, value, null, null, DictStateMask.All, OperationState.Default);
			if(item != null){
				oid = item.getID();
			}
		
			
			return oid;
		}
	}
	
	@Override
	public Object[][] getImplTable() {
		return new Object[][] { 
				{ "GetDictValue", new GetDictValueImpl() },
				{ "GetDictOID", new GetDictOIDImpl() }
			};
	}

}
