/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.mid.util;

import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class Seed {
    public static final String SYS_SEED_TABLE = "Sys_IDSeed";
    private static final String SELECT_SQL = "select SeedMark from Sys_IDSeed where SeedID=? ";
    private static final String UPDATE_SQL = "update Sys_IDSeed set SeedMark=? where SeedID=?";
    private static final String AUTO_PLUS_UPDATE_SQL = "update Sys_IDSeed set SeedMark=SeedMark+? where SeedID=?";
    private static final String INSERT_SQL = "insert into Sys_IDSeed(SeedID,SeedMark,Description,CreateTime) values(?,?,?,?)";
    public static Long IntervalWidth = 256L;
    private int seedType = -1;
    private String description = "";
    private Long begin = -1L;
    private Long end = -1L;
    private boolean init = false;
    private Integer startIndex = 0;

    public Seed(int n, String string) {
        this.seedType = n;
        this.description = string;
    }

    public Seed(int n, String string, Integer n2) {
        this.seedType = n;
        this.description = string;
        this.startIndex = n2;
    }

    public Long applyID(DefaultContext defaultContext) throws Throwable {
        try (IDBManager iDBManager = null;){
            if (!this.init) {
                iDBManager = defaultContext.newDBManager();
                this.init(iDBManager);
            }
            if (this.begin >= this.end) {
                if (iDBManager == null) {
                    iDBManager = defaultContext.newDBManager();
                }
                this.applyNewInterval(iDBManager);
            }
            if (iDBManager != null) {
                iDBManager.commit();
            }
        }
        this.begin = this.begin + 1L;
        return this.begin;
    }

    public Long[] applyID(DefaultContext defaultContext, int n) throws Throwable {
        Long[] longArray = new Long[n];
        try (IDBManager iDBManager = null;){
            if (!this.init) {
                iDBManager = defaultContext.newDBManager();
                this.init(iDBManager);
            }
            for (int k = 0; k < n; ++k) {
                if (this.begin >= this.end) {
                    if (iDBManager == null) {
                        iDBManager = defaultContext.newDBManager();
                    }
                    this.applyNewInterval(iDBManager);
                }
                longArray[k] = this.begin = Long.valueOf(this.begin + 1L);
            }
            if (iDBManager != null) {
                iDBManager.commit();
            }
        }
        return longArray;
    }

    private void init(IDBManager iDBManager) throws Throwable {
        Statement statement;
        block8: {
            statement = null;
            ResultSet resultSet = null;
            try {
                PSArgs pSArgs = new PSArgs();
                pSArgs.addArg(1001, this.seedType);
                iDBManager.setRowLock(SYS_SEED_TABLE, "SeedID=?", pSArgs);
                statement = iDBManager.preparedQueryStatement(SELECT_SQL);
                resultSet = iDBManager.executeQuery((PreparedStatement)statement, SELECT_SQL, pSArgs);
                boolean bl = resultSet.next();
                if (bl) {
                    this.begin = resultSet.getLong(1);
                    this.end = this.begin + IntervalWidth;
                }
                resultSet.close();
                statement.close();
                if (bl) {
                    statement = iDBManager.preparedUpdateStatement(UPDATE_SQL);
                    PSArgs pSArgs2 = new PSArgs();
                    pSArgs2.addArg(1010, this.end);
                    pSArgs2.addArg(1001, this.seedType);
                    iDBManager.executeUpdate((PreparedStatement)statement, UPDATE_SQL, pSArgs2);
                } else {
                    statement = iDBManager.preparedUpdateStatement(INSERT_SQL);
                    PSArgs pSArgs3 = new PSArgs();
                    pSArgs3.addArg(1001, this.seedType);
                    pSArgs3.addArg(1010, (long)this.startIndex.intValue() + IntervalWidth);
                    pSArgs3.addArg(1002, this.description);
                    pSArgs3.addArg(1003, new Date(System.currentTimeMillis()));
                    iDBManager.executeUpdate((PreparedStatement)statement, INSERT_SQL, pSArgs3);
                    this.begin = this.startIndex.longValue();
                    this.end = (long)this.startIndex.intValue() + IntervalWidth;
                }
                this.init = true;
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
            return;
        }
    }

    private void applyNewInterval(IDBManager iDBManager) throws Throwable {
        Statement statement;
        block6: {
            statement = null;
            ResultSet resultSet = null;
            try {
                if (IntervalWidth < 524288L) {
                    IntervalWidth = IntervalWidth << 1;
                }
                PSArgs pSArgs = new PSArgs();
                pSArgs.addLongArg(IntervalWidth);
                pSArgs.addIntArg(this.seedType);
                statement = iDBManager.preparedUpdateStatement(AUTO_PLUS_UPDATE_SQL);
                iDBManager.executeUpdate((PreparedStatement)statement, AUTO_PLUS_UPDATE_SQL, pSArgs);
                statement.close();
                statement = iDBManager.preparedQueryStatement(SELECT_SQL);
                pSArgs = new PSArgs();
                pSArgs.addIntArg(this.seedType);
                resultSet = iDBManager.executeQuery((PreparedStatement)statement, SELECT_SQL, pSArgs);
                resultSet.next();
                this.end = resultSet.getLong(1);
                this.begin = this.end - IntervalWidth;
                if (resultSet == null) break block6;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
            return;
        }
    }
}

