/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.mid.connection;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.connection.PartitionInfo;
import com.bokesoft.yigo.mid.connection.TableInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataBaseInfo {
    private HashMap<String, TableInfo> set = new HashMap();
    private Set<String> viewSet = new HashSet<String>();

    public void initTable(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
            String string = resultSet.getString(1).toUpperCase();
            this.set.put(string, new TableInfo());
        }
    }

    public void initView(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
            String string = resultSet.getString(1).toUpperCase();
            this.viewSet.add(string);
        }
    }

    public void initColumn(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
            String string = resultSet.getString(1).toUpperCase();
            String string2 = resultSet.getString(2).toUpperCase();
            TableInfo tableInfo = this.set.get(string2);
            if (tableInfo != null) {
                tableInfo.put(string);
                continue;
            }
            throw new RuntimeException("For " + string2 + "." + string + ", Table " + string2 + " does not exists in tables");
        }
    }

    public void initColumn(ResultSet resultSet, String string) throws SQLException {
        while (resultSet.next()) {
            String string2 = resultSet.getString(2).toUpperCase();
            String string3 = string;
            TableInfo tableInfo = this.set.get(string3);
            if (tableInfo != null) {
                tableInfo.put(string2);
                continue;
            }
            throw new RuntimeException("For " + string3 + "." + string2 + ", Table " + string3 + " does not exists in tables");
        }
    }

    public void initIndex(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
            int n;
            String string = resultSet.getString(1).toUpperCase();
            String string2 = resultSet.getString(2).toUpperCase();
            this.set.get(string2).putIndex(string);
            String string3 = resultSet.getString(3).toUpperCase();
            if (!StringUtil.isBlankOrNull((String)string3)) {
                if (this.set.get(string2) != null && this.set.get(string2).getIndexColumnSet().containsKey(string)) {
                    string3 = this.set.get(string2).getIndexColumnSet().get(string) + "," + string3;
                }
                this.set.get(string2).putIndexColumn(string, string3);
            }
            if ((n = resultSet.getInt(4)) < 0) continue;
            Boolean bl = Boolean.FALSE;
            if (n == 0) {
                bl = Boolean.TRUE;
            }
            this.set.get(string2).putUniqueIndex(string, bl);
        }
    }

    public void initPartition(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
            Object object = resultSet.getString(1).toUpperCase();
            String string = resultSet.getString(2);
            String string2 = resultSet.getString(3);
            object = this.set.get(object).getPartitionInfo();
            ((PartitionInfo)object).setPartitionMethod(string);
            ((PartitionInfo)object).putPartitionColumnSet(string2);
        }
    }

    public boolean checkTableExist(String string) {
        return this.set.containsKey(string.toUpperCase());
    }

    public boolean checkViewExist(String string) {
        return this.viewSet.contains(string.toUpperCase());
    }

    public HashSet<String> getTableColumnSet(String string) {
        return this.set.get(string.toUpperCase()).getColumnSet();
    }

    public HashSet<String> getIndexSet(String string) {
        return this.set.get(string.toUpperCase()).getIndexSet();
    }

    public void updateColumnInfo(String object, List<MetaSchemaColumn> metaSchemaColumn2) {
        TableInfo tableInfo = this.set.get(object = ((String)object).toUpperCase());
        if (tableInfo == null) {
            tableInfo = new TableInfo();
            this.set.put((String)object, tableInfo);
        }
        for (MetaSchemaColumn metaSchemaColumn2 : metaSchemaColumn2) {
            tableInfo.put(metaSchemaColumn2.getKey().toUpperCase());
        }
    }

    public void updateIndexInfo(String object, List<MetaIndex> metaIndex2) {
        TableInfo tableInfo = this.set.get(object = ((String)object).toUpperCase());
        if (tableInfo == null) {
            tableInfo = new TableInfo();
            this.set.put((String)object, tableInfo);
        }
        for (MetaIndex metaIndex2 : metaIndex2) {
            tableInfo.put(metaIndex2.getKey().toUpperCase());
            tableInfo.putIndexColumn(metaIndex2.getKey().toUpperCase(), metaIndex2.getColumns());
            tableInfo.putUniqueIndex(metaIndex2.getKey().toUpperCase(), metaIndex2.isUnique());
        }
    }

    public void updatePartitionInfo(MetaSchemaTable metaSchemaTable) {
        PartitionInfo partitionInfo = this.getPartitionInfo(metaSchemaTable.getKey().toUpperCase());
        partitionInfo.setPartitionMethod(metaSchemaTable.getPartitionMethod());
        partitionInfo.putPartitionColumnSet(metaSchemaTable.getPartitionColumnSet());
    }

    public void updateInfo(MetaSchemaTable metaSchemaTable) {
        String string = metaSchemaTable.getKey().toUpperCase();
        TableInfo tableInfo = this.set.get(string);
        if (tableInfo == null) {
            tableInfo = new TableInfo();
            this.set.put(string, tableInfo);
        }
        for (MetaSchemaColumn metaSchemaColumn : metaSchemaTable.getColumnCollection()) {
            tableInfo.put(metaSchemaColumn.getKey().toUpperCase());
        }
        if (metaSchemaTable.getIndexCollection() != null) {
            for (MetaSchemaColumn metaSchemaColumn : metaSchemaTable.getIndexCollection()) {
                tableInfo.putIndex(metaSchemaColumn.getKey().toUpperCase());
                tableInfo.putIndexColumn(metaSchemaColumn.getKey().toUpperCase(), metaSchemaColumn.getColumns());
                tableInfo.putUniqueIndex(metaSchemaColumn.getKey().toUpperCase(), metaSchemaColumn.isUnique());
            }
        }
    }

    public PartitionInfo getPartitionInfo(String string) {
        return this.set.get(string.toUpperCase()).getPartitionInfo();
    }

    public HashMap<String, String> getIndexColumnSet(String string) {
        return this.set.get(string.toUpperCase()).getIndexColumnSet();
    }

    public HashMap<String, Boolean> getUniqueIndexSet(String string) {
        return this.set.get(string.toUpperCase()).getUniqueIndexSet();
    }
}

