/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.mid.base;

import com.bokesoft.yes.mid.base.MidVE;
import com.bokesoft.yes.mid.dsn.DSNFactory;
import com.bokesoft.yes.mid.parser.MidParser;
import com.bokesoft.yes.parser.EvalScope;
import com.bokesoft.yes.parser.IFuncImplMap;
import com.bokesoft.yes.parser.IObjectLoop;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.dsn.IDSNFactory;
import com.bokesoft.yigo.parser.IEval;
import com.bokesoft.yigo.parser.IEvalContext;
import com.bokesoft.yigo.parser.IExecutor;
import com.bokesoft.yigo.struct.env.Env;
import com.bokesoft.yigo.tools.ve.VE;
import java.util.Map;
import javax.script.ScriptEngine;

public abstract class BaseContext
implements IServiceContext,
IEvalContext {
    protected MidVE ve = null;
    protected IDBManager dbManager = null;
    protected MidParser<BaseContext> parser = null;
    private EvalScope scope = null;
    public static final Integer TYPE = 1;

    public BaseContext(MidVE midVE) {
        this.ve = midVE;
    }

    @Override
    public MidVE getVE() {
        return this.ve;
    }

    protected abstract IFuncImplMap getFunctionImplMap();

    public IEval<BaseContext> getMidParser() {
        if (this.parser == null) {
            BaseContext baseContext = this;
            this.parser = new MidParser<BaseContext>(baseContext, baseContext.getFunctionImplMap());
        }
        return this.parser;
    }

    @Override
    public void setVE(VE vE) {
        this.ve = (MidVE)vE;
    }

    @Override
    public void commit() throws Throwable {
        if (this.dbManager != null) {
            this.dbManager.commit();
        }
    }

    @Override
    public void rollback() throws Throwable {
        if (this.dbManager != null) {
            this.dbManager.rollback();
        }
    }

    @Override
    public void close() throws Throwable {
        if (this.dbManager != null) {
            this.dbManager.close();
            this.dbManager = null;
        }
        if (this.ve != null) {
            this.ve.destory();
        }
    }

    public abstract ScriptEngine ensureScriptEngine() throws Throwable;

    public abstract Object getValue(BaseContext var1, EvalScope var2, String var3, String var4) throws Throwable;

    public abstract void setValue(BaseContext var1, EvalScope var2, String var3, String var4, Object var5) throws Throwable;

    public abstract Object checkMacro(BaseContext var1, String var2) throws Throwable;

    public abstract Object evalMacro(BaseContext var1, EvalScope var2, String var3, Object var4, Object[] var5, IExecutor var6) throws Throwable;

    public abstract IObjectLoop getLoop(BaseContext var1, String var2, int var3, Object var4) throws Throwable;

    public abstract Object evalObject(BaseContext var1, String var2, String var3, Object[] var4) throws Throwable;

    public void setScope(EvalScope evalScope) {
        this.scope = evalScope;
    }

    public EvalScope getScope() {
        return this.scope;
    }

    public Env getEnv() {
        return this.ve.getEnv();
    }

    public IDBManager getDBManager() throws Throwable {
        if (this.ve.getDSN() != null && this.dbManager == null) {
            IDSNFactory iDSNFactory = DSNFactory.getInstance();
            BaseContext baseContext = this;
            this.dbManager = (IDBManager)iDSNFactory.createDSN(baseContext, baseContext.ve.getDSN(), null);
        }
        return this.dbManager;
    }

    public void build(Map<String, Object> map, String string, long l, long l2, int n) {
        this.ve.getEnv().setSessionParas(map);
        this.ve.getEnv().setClientID(string);
        this.ve.getEnv().setClusterid(l);
        this.ve.getEnv().setUserID(Long.valueOf(l2));
        this.ve.getEnv().setMode(n);
    }

    public IDBManager newDBManager() throws Throwable {
        BaseContext baseContext = this;
        return (IDBManager)DSNFactory.getInstance().createDSN(baseContext, baseContext.ve.getDSN(), null);
    }

    public abstract String getFormKey();

    public abstract long getOID();

    @Override
    public void doMidActions() throws Throwable {
    }
}

