/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.service.filter;

import com.bokesoft.yes.mid.service.filter.ChainFilter;
import com.bokesoft.yes.mid.service.filter.IFilterMatcher;
import com.bokesoft.yigo.mid.service.IServiceFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ServiceFilterFactory {
    private static ServiceFilterFactory INSTANCE = null;
    private List<IFilterMatcher> matchers = null;

    private ServiceFilterFactory() {
    }

    public static ServiceFilterFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ServiceFilterFactory();
        }
        return INSTANCE;
    }

    public IServiceFilter create(String string, Map<String, Object> map) throws Throwable {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (this.matchers != null) {
            ChainFilter chainFilter = new ChainFilter();
            Iterator<IFilterMatcher> iterator = this.matchers.iterator();
            while (iterator.hasNext()) {
                List<IServiceFilter> list = iterator.next().find(string, map);
                if (list == null) continue;
                chainFilter.addFilters(list);
            }
            if (!chainFilter.isEmpty()) {
                chainFilter.sortFilters();
                return chainFilter;
            }
        }
        return null;
    }

    public void setMatcher(IFilterMatcher iFilterMatcher) {
        if (this.matchers == null) {
            this.matchers = new ArrayList<IFilterMatcher>();
        }
        this.matchers.add(iFilterMatcher);
    }
}

