/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.server.weight.action;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.server.weight.WeightServiceCenter;
import com.bokesoft.yes.mid.server.weight.action.IConsumeAction;
import com.bokesoft.yes.mid.server.weight.action.ISetTimeoutAction;
import com.bokesoft.yes.mid.server.weight.card.SqlTimeCard;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.sql.SQLException;
import java.time.LocalDateTime;

public class SqlTimePOS
implements IConsumeAction<ISetTimeoutAction, String> {
    private long startTime = 0L;

    @Override
    public void start(ISetTimeoutAction iSetTimeoutAction) throws SQLException {
        try {
            SqlTimeCard sqlTimeCard = WeightServiceCenter.getInstance().getCurSqlTimeCard();
            if (sqlTimeCard != null) {
                SqlTimeCard sqlTimeCard2 = sqlTimeCard;
                long l = sqlTimeCard2.frozen(sqlTimeCard2.getBalance());
                iSetTimeoutAction.setTimeOut(TypeConvertor.toInteger((Object)(l / 1000L)));
                this.startTime = System.currentTimeMillis();
            }
            return;
        }
        catch (Throwable throwable) {
            logger.error(throwable.getMessage());
            throw new SQLException(throwable);
        }
    }

    @Override
    public String end(Object object) throws SQLException {
        SqlTimeCard sqlTimeCard = WeightServiceCenter.getInstance().getCurSqlTimeCard();
        if (sqlTimeCard == null) {
            return null;
        }
        long l = System.currentTimeMillis() - this.startTime;
        long l2 = sqlTimeCard.getTotalCosted();
        long l3 = sqlTimeCard.getBalance();
        try {
            l3 = sqlTimeCard.consume(l);
            if (sqlTimeCard.isWarnMode()) {
                String string = StringUtil.strcat((Object[])new Object[]{Thread.currentThread().getName(), "\u3010", LocalDateTime.now(), "\u3011 ticket:", sqlTimeCard.getTicket(), "; sql time costs:", l, "ms; history accumulate costs:", l2, "ms; balance:", l3, "ms;", " -> ", object});
                logger.warn(string);
                this.logStackTrack();
            }
            return null;
        }
        catch (Throwable throwable) {
            object = StringUtil.strcat((Object[])new Object[]{Thread.currentThread().getName(), "\u3010", LocalDateTime.now(), "\u3011 ticket:", sqlTimeCard.getTicket(), "; error:", throwable.getMessage(), "; history accumulate costs:", l2, "ms; balance:", l3, "ms;", " -> ", object});
            logger.error((String)object);
            this.logStackTrack();
            throw new SQLException(throwable);
        }
    }

    private void logStackTrack() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray != null && stackTraceElementArray.length > 1) {
            for (int k = 1; k < stackTraceElementArray.length && k < 15; ++k) {
                if (stackTraceElementArray[k] == null) continue;
                logger.warn(stackTraceElementArray[k].toString());
            }
        }
        logger.warn("##############################################################");
    }
}

