/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.rights.io;

import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.rights.io.IRightsIO;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.common.MetaServiceRights;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.rights.MetaRightsDefinition;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.rights.CustomRights;
import com.bokesoft.yigo.struct.rights.DictRights;
import com.bokesoft.yigo.struct.rights.EntryRights;
import com.bokesoft.yigo.struct.rights.FormRights;
import com.bokesoft.yigo.struct.rights.ServiceRights;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class OperatorRightsDBIO
implements IRightsIO {
    @Override
    public EntryRights loadEntryRights(DefaultContext defaultContext, long l) throws Throwable {
        EntryRights entryRights = new EntryRights();
        if (this.checkIsAdmin(defaultContext.getDBManager(), l).booleanValue()) {
            entryRights.setAllRights(true);
            return entryRights;
        }
        String string = "select EntryKey from Sys_OperatorEntryRights where OperatorID = ?";
        if ((defaultContext = defaultContext.getDBManager().execPrepareQuery(string, l)).first()) {
            while (!defaultContext.isAfterLast()) {
                entryRights.addEntryKey(TypeConvertor.toString((Object)defaultContext.getObject("EntryKey")));
                defaultContext.next();
            }
        }
        entryRights.addEntryKey("config/ChangePassWord");
        return entryRights;
    }

    @Override
    public DictRights loadDictRights(DefaultContext defaultContext, long l, String string) throws Throwable {
        IMetaFactory iMetaFactory = defaultContext.getVE().getMetaFactory();
        MetaDataObject metaDataObject = iMetaFactory.getDataObject(string);
        if (metaDataObject == null) {
            throw new Exception(string + "\u5bf9\u5e94\u7684\u5b57\u5178\u4e0d\u5b58\u5728");
        }
        DictRights dictRights = new DictRights(string);
        if (this.checkIsAdmin(defaultContext.getDBManager(), l).booleanValue() || iMetaFactory.hasAllDictRights(string)) {
            dictRights.setAllRights(true);
        } else {
            string = metaDataObject.getMainTable().getBindingDBTableName().toUpperCase();
            string = string + "_OR";
            string = "select DictID, HasRead, HasWrite from " + string + " where OperatorID=?";
            if ((defaultContext = defaultContext.getDBManager().execPrepareQuery(string, l)).first()) {
                while (!defaultContext.isAfterLast()) {
                    long l2 = TypeConvertor.toLong((Object)defaultContext.getObject(0));
                    int n = TypeConvertor.toInteger((Object)defaultContext.getObject(1));
                    int n2 = TypeConvertor.toInteger((Object)defaultContext.getObject(2));
                    if (l2 == -1L) {
                        dictRights.getIDs().clear();
                        dictRights.setAllRights(true);
                        dictRights.setEmptRights(true);
                        return dictRights;
                    }
                    if (l2 == 0L) {
                        dictRights.setEmptRights(true);
                    }
                    dictRights.addDictID(l2);
                    if (n == 1) {
                        dictRights.addReadRightsDictID(l2);
                    }
                    if (n2 == 1) {
                        dictRights.addWriteRightsDictID(l2);
                    }
                    defaultContext.next();
                }
            }
        }
        return dictRights;
    }

    @Override
    public FormRights loadFormRights(DefaultContext defaultContext, long l, String string) throws Throwable {
        Object object = defaultContext.getVE().getMetaFactory();
        FormRights formRights = new FormRights(string);
        if (this.checkIsAdmin(defaultContext.getDBManager(), l).booleanValue() || object.hasAllFormRights(string)) {
            formRights.setAllVisibleRights(true);
            formRights.setAllEnableRights(true);
            formRights.setAllOptRights(true);
            formRights.setDefStatus(false);
        } else {
            String string2;
            object = "select FieldKey, Visible, Enable from SYS_OperatorFieldRights where OperatorID=? and FormKey=?";
            object = defaultContext.getDBManager().execPrepareQuery((String)object, l, string);
            if (object.first()) {
                formRights.setDefStatus(false);
                while (!object.isAfterLast()) {
                    string2 = object.getString("FieldKey");
                    int n = TypeConvertor.toInteger((Object)object.getObject("Visible"));
                    int n2 = TypeConvertor.toInteger((Object)object.getObject("Enable"));
                    if (!string2.equalsIgnoreCase("*")) {
                        if (n == 0) {
                            formRights.addVisibleRights(string2);
                        }
                        if (n2 == 0) {
                            formRights.addEnableRights(string2);
                        }
                    }
                    object.next();
                }
            }
            string2 = "select OptKey from SYS_OperatorOptRights where OperatorID=? and FormKey=?";
            DataTable dataTable = defaultContext.getDBManager().execPrepareQuery(string2, l, string);
            if (dataTable.first()) {
                while (!dataTable.isAfterLast()) {
                    String string3 = dataTable.getString("OptKey");
                    formRights.addOptRights(string3);
                    dataTable.next();
                }
            }
        }
        return formRights;
    }

    @Override
    public void saveEntryRights(DefaultContext defaultContext, long l, EntryRights object) throws Throwable {
        String string = "insert into SYS_OperatorEntryRights (OperatorID, EntryKey) values (?,?)";
        String string22 = "delete from SYS_OperatorEntryRights where OperatorID=?";
        defaultContext.getDBManager().execPrepareUpdate(string22, l);
        if (object.hasAllRights()) {
            defaultContext.getDBManager().execPrepareUpdate(string, l, "*");
            return;
        }
        for (String string22 : object.getRightsList()) {
            defaultContext.getDBManager().execPrepareUpdate(string, l, string22);
        }
    }

    @Override
    public void saveDictRights(DefaultContext defaultContext, long l, DictRights object, Collection<Long> collection, Collection<Long> collection2, Collection<Long> collection3) throws Throwable {
        Object object2 = object.getItemKey();
        this.clearDictRights(defaultContext, (String)object2, l);
        object2 = defaultContext.getVE().getMetaFactory().getDataObject((String)object2);
        String string = object2.getMainTable().getBindingDBTableName();
        String string2 = string + "_OR";
        if (object.hasAllRights()) {
            if (collection == null || collection.isEmpty()) {
                object2 = "insert into " + string2 + "(OperatorID, DictID, HasRead, HasWrite) values(?, ?,?,?)";
                defaultContext.getDBManager().execPrepareUpdate((String)object2, l, -1, -1, -1);
                return;
            }
            object2 = object2.getMainTable().getOIDColumn().getBindingDBColumnName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("insert into ");
            stringBuffer.append(string2);
            stringBuffer.append(" (OperatorID, DictID, HasRead, HasWrite) ");
            stringBuffer.append("select ");
            stringBuffer.append(l);
            stringBuffer.append(", " + (String)object2 + " from ");
            stringBuffer.append(string);
            stringBuffer.append(" where " + (String)object2 + " > 0");
            defaultContext.getDBManager().execPrepareUpdate(stringBuffer.toString(), new Object[0]);
            object = "delete from " + string2 + " where OperatorID = ? and DictID = ?";
            object2 = new BatchPsPara((String)object);
            new PSArgs();
            for (long l2 : collection) {
                PSArgs pSArgs = new PSArgs();
                pSArgs.addLongArg(l);
                pSArgs.addLongArg(l2);
                ((BatchPsPara)object2).putArgs(pSArgs);
            }
            defaultContext.getDBManager().executeUpdate((BatchPsPara)object2);
            return;
        }
        if (object.size() == 0) {
            return;
        }
        object2 = "insert into " + string2 + "(OperatorID, DictID, HasRead, HasWrite) values(" + l + ", ?,?,?)";
        BatchPsPara batchPsPara = new BatchPsPara((String)object2);
        new PSArgs();
        object2 = object.getIDs().iterator();
        while (object2.hasNext()) {
            long l3 = (Long)object2.next();
            object = new PSArgs();
            ((PSArgs)object).addLongArg(l3);
            int n = 0;
            int n2 = 0;
            if (collection2.contains(l3)) {
                n = 1;
            }
            if (collection3.contains(l3)) {
                n2 = 1;
            }
            ((PSArgs)object).addIntArg(n);
            ((PSArgs)object).addIntArg(n2);
            batchPsPara.putArgs((PSArgs)object);
        }
        defaultContext.getDBManager().executeUpdate(batchPsPara);
    }

    @Override
    public void appendDictRights(DefaultContext defaultContext, String string, long l, Collection<Long> collection, Collection<Long> object, Collection<Long> collection2, Collection<Long> collection3) throws Throwable {
        Object object2;
        string = defaultContext.getVE().getMetaFactory().getDataObject(string).getMainTable().getBindingDBTableName();
        string = string + "_OR";
        if (object != null && !object.isEmpty()) {
            object2 = "delete from " + string + " where OperatorID = ? and DictID = ?";
            object2 = new BatchPsPara((String)object2);
            new PSArgs();
            Iterator<Long> iterator = object.iterator();
            while (iterator.hasNext()) {
                long l2 = iterator.next();
                object = new PSArgs();
                ((PSArgs)object).addLongArg(l);
                ((PSArgs)object).addLongArg(l2);
                ((BatchPsPara)object2).putArgs((PSArgs)object);
            }
            defaultContext.getDBManager().executeUpdate((BatchPsPara)object2);
        }
        if (collection != null && !collection.isEmpty()) {
            object2 = "insert into " + string + "(OperatorID, DictID, HasRead, HasWrite) values(" + l + ", ?,?,?)";
            object2 = new BatchPsPara((String)object2);
            new PSArgs();
            for (long l2 : collection) {
                object = new PSArgs();
                ((PSArgs)object).addLongArg(l2);
                int n = 0;
                int n2 = 0;
                if (collection2.contains(l2)) {
                    n = 1;
                }
                if (collection3.contains(l2)) {
                    n2 = 1;
                }
                ((PSArgs)object).addIntArg(n);
                ((PSArgs)object).addIntArg(n2);
                ((BatchPsPara)object2).putArgs((PSArgs)object);
            }
            defaultContext.getDBManager().executeUpdate((BatchPsPara)object2);
        }
    }

    private void clearDictRights(DefaultContext defaultContext, String string, long l) throws Throwable {
        string = defaultContext.getVE().getMetaFactory().getDataObject(string).getMainTable().getBindingDBTableName();
        string = string + "_OR";
        string = "delete from " + string + " where OperatorID = ?";
        defaultContext.getDBManager().execPrepareUpdate(string, l);
    }

    @Override
    public void saveFormRights(DefaultContext defaultContext, long l, FormRights formRights) throws Throwable {
        String string = "insert into SYS_OperatorOptRights (OperatorID, FormKey, OptKey) values (?,?,?)";
        String string22 = "delete from SYS_OperatorOptRights where OperatorID=? and FormKey=?";
        String string3 = formRights.getFormKey();
        defaultContext.getDBManager().execPrepareUpdate(string22, l, string3);
        if (formRights.hasAllOptRights()) {
            defaultContext.getDBManager().execPrepareUpdate(string, l, string3, "*");
        } else {
            for (String string22 : formRights.getOptRights()) {
                defaultContext.getDBManager().execPrepareUpdate(string, l, string3, string22);
            }
        }
        string22 = "insert into SYS_OperatorFieldRights (OperatorID, FormKey, FieldKey, Visible, Enable) values (?,?,?,?,?)";
        Object object2 = "delete from SYS_OperatorFieldRights where OperatorID=? and FormKey=? ";
        defaultContext.getDBManager().execPrepareUpdate((String)object2, l, string3);
        if (formRights.hasAllVisibleRights() && formRights.hasAllEnableRights()) {
            defaultContext.getDBManager().execPrepareUpdate(string22, l, string3, "*", -1, -1);
        }
        if (!formRights.hasAllVisibleRights() || !formRights.hasAllEnableRights()) {
            for (Object object2 : formRights.getEnableRights()) {
                defaultContext.getDBManager().execPrepareUpdate(string22, l, string3, object2, TypeConvertor.toInteger((Object)formRights.hasVisibleRights((String)object2)), 0);
            }
        }
    }

    @Override
    public CustomRights loadCustomRights(DefaultContext defaultContext, long l) throws Throwable {
        CustomRights customRights = new CustomRights();
        if (this.checkIsAdmin(defaultContext.getDBManager(), l).booleanValue()) {
            customRights.setHasAllRights(true);
        } else {
            String string = "select GroupKey, OptKey from SYS_OperatorCustomOptRights where OperatorID=?";
            defaultContext = defaultContext.getDBManager().execPrepareQuery(string, l);
            defaultContext.beforeFirst();
            while (defaultContext.next()) {
                customRights.addRights(defaultContext.getString("GroupKey"), defaultContext.getString("OptKey"));
            }
        }
        return customRights;
    }

    @Override
    public void saveCustomRights(DefaultContext defaultContext, long l, CustomRights object) throws Throwable {
        Object object2 = "insert into SYS_OperatorCustomOptRights (OperatorID,GroupKey,OptKey,HasRights) values (?,?,?,?)";
        Object object32 = "delete from SYS_OperatorCustomOptRights where OperatorID=? ";
        defaultContext.getDBManager().execPrepareUpdate((String)object32, l);
        if (object.isHasAllRights()) {
            defaultContext.getDBManager().execPrepareUpdate((String)object2, l, "*", "*", 1);
            return;
        }
        object2 = new BatchPsPara((String)object2);
        for (Object object32 : object.CustomRightsSet()) {
            for (String string : (Set)object32.getValue()) {
                PSArgs pSArgs = new PSArgs();
                ((BatchPsPara)object2).putArgs(pSArgs);
                pSArgs.addLongArg(l);
                pSArgs.addStringArg((String)object32.getKey());
                pSArgs.addStringArg(string);
                pSArgs.addIntArg(1);
            }
        }
        defaultContext.getDBManager().executeUpdate((BatchPsPara)object2);
    }

    @Override
    public void saveServiceRights(DefaultContext defaultContext, long l, ServiceRights object) throws Throwable {
        Object object2 = "insert into SYS_OperatorServiceRights (OperatorID, ServiceID) values (?,?)";
        String string2 = "delete from SYS_OperatorServiceRights where OperatorID=?";
        defaultContext.getDBManager().execPrepareUpdate(string2, l);
        if (object.hasAllRights()) {
            defaultContext.getDBManager().execPrepareUpdate((String)object2, l, "*");
            return;
        }
        object2 = new BatchPsPara((String)object2);
        for (String string2 : object.getServiceIDs()) {
            PSArgs pSArgs = new PSArgs();
            pSArgs.addLongArg(l);
            pSArgs.addStringArg(string2);
            ((BatchPsPara)object2).putArgs(pSArgs);
        }
        defaultContext.getDBManager().executeUpdate((BatchPsPara)object2);
    }

    @Override
    public void saveServiceRights(DefaultContext defaultContext, long l, ServiceRights serviceRights, ServiceRights object) throws Throwable {
        PSArgs pSArgs;
        Object object2 = "delete from SYS_OperatorServiceRights where OperatorID = ? and ServiceID = ? ";
        String string = "insert into SYS_OperatorServiceRights (OperatorID, ServiceID, Owner, Enable) values (?,?,'0','1')";
        if (object.getServiceIDs() != null || !object.getServiceIDs().isEmpty() || object.getServiceIDs().size() > 0) {
            object2 = new BatchPsPara((String)object2);
            for (String string2 : object.getServiceIDs()) {
                pSArgs = new PSArgs();
                pSArgs.addLongArg(l);
                pSArgs.addStringArg(string2);
                ((BatchPsPara)object2).putArgs(pSArgs);
            }
            defaultContext.getDBManager().executeUpdate((BatchPsPara)object2);
        }
        if (!(serviceRights.getServiceIDs() == null && serviceRights.getServiceIDs().isEmpty() && serviceRights.getServiceIDs().size() <= 0 || serviceRights.hasAllRights())) {
            object2 = new BatchPsPara(string);
            for (String string2 : serviceRights.getServiceIDs()) {
                pSArgs = new PSArgs();
                pSArgs.addLongArg(l);
                pSArgs.addStringArg(string2);
                ((BatchPsPara)object2).putArgs(pSArgs);
            }
            defaultContext.getDBManager().executeUpdate((BatchPsPara)object2);
        }
    }

    private void differSets(ServiceRights serviceRights, ServiceRights serviceRights2, ServiceRights serviceRights3, ServiceRights serviceRights4) {
        if ((serviceRights == null || serviceRights.getServiceIDs().isEmpty()) && (serviceRights2 == null || serviceRights2.getServiceIDs().isEmpty())) {
            return;
        }
        if (serviceRights != null && !serviceRights.getServiceIDs().isEmpty() && (serviceRights2 == null || serviceRights2.getServiceIDs().isEmpty())) {
            serviceRights3.getServiceIDs().addAll(serviceRights.getServiceIDs());
            return;
        }
        if ((serviceRights == null || serviceRights.getServiceIDs().isEmpty()) && serviceRights2 != null && !serviceRights2.getServiceIDs().isEmpty()) {
            serviceRights4.getServiceIDs().addAll(serviceRights2.getServiceIDs());
            return;
        }
        if (serviceRights != null && !serviceRights.getServiceIDs().isEmpty() && serviceRights2 != null && !serviceRights2.getServiceIDs().isEmpty()) {
            for (Object object : serviceRights2.getServiceIDs()) {
                if (serviceRights.getServiceIDs().contains(object)) {
                    object = serviceRights.getServiceIDs().iterator();
                    while (object.hasNext()) {
                        String string = (String)object.next();
                        if (serviceRights2.getServiceIDs().contains(string)) continue;
                        serviceRights3.getServiceIDs().add(string);
                    }
                    continue;
                }
                serviceRights4.getServiceIDs().add(object);
            }
        }
    }

    @Override
    public ServiceRights loadServiceRights(DefaultContext defaultContext, long l) throws Throwable {
        MetaServiceRights metaServiceRights;
        Object object;
        ServiceRights serviceRights = new ServiceRights();
        if (this.checkIsAdmin(defaultContext.getDBManager(), l).booleanValue()) {
            serviceRights.setHasAllRights(true);
            return serviceRights;
        }
        IMetaFactory iMetaFactory = defaultContext.getVE().getMetaFactory();
        Object object2 = iMetaFactory.getMetaFormList();
        MetaRightsDefinition metaRightsDefinition = iMetaFactory.getRightsDefinition();
        if (metaRightsDefinition != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = ((MetaFormProfile)object.next()).getKey();
                if (iMetaFactory.hasAllFormRights((String)object2) || (object2 = defaultContext.getVE().getMetaFactory().getMetaForm((String)object2).getServiceRightsCollection()) == null) continue;
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    metaServiceRights = (MetaServiceRights)object2.next();
                    serviceRights.addServiceID(metaServiceRights.getKey());
                }
            }
        }
        object = "select FormKey, OptKey from SYS_OperatorOptRights where OperatorID=?";
        DataTable dataTable = defaultContext.getDBManager().execPrepareQuery((String)object, l);
        if (dataTable.first()) {
            while (!dataTable.isAfterLast()) {
                object2 = dataTable.getString("FormKey");
                String string = dataTable.getString("OptKey");
                if (metaRightsDefinition != null && iMetaFactory.hasAllFormRights((String)object2)) continue;
                object2 = defaultContext.getVE().getMetaFactory().getMetaForm((String)object2).getServiceRightsCollection();
                if (object2 != null) {
                    object2 = object2.iterator();
                    while (object2.hasNext()) {
                        metaServiceRights = (MetaServiceRights)object2.next();
                        if (!metaServiceRights.getRefOperation().equals(string)) continue;
                        serviceRights.addServiceID(metaServiceRights.getKey());
                    }
                }
                dataTable.next();
            }
        }
        return serviceRights;
    }

    @Override
    public void appendServiceRights(DefaultContext defaultContext, long l, Collection<String> collection, Collection<String> iterator) throws Throwable {
        PSArgs pSArgs;
        String string = "insert into Sys_OperatorServiceRights (OperatorID, ServiceID) values (?,?)";
        Object object = "delete from Sys_OperatorServiceRights where OperatorID = ? and ServiceID = ?";
        if (iterator != null && iterator.size() > 0) {
            object = new BatchPsPara((String)object);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                pSArgs = new PSArgs();
                pSArgs.addLongArg(l);
                pSArgs.addStringArg(string2);
                ((BatchPsPara)object).putArgs(pSArgs);
            }
            defaultContext.getDBManager().executeUpdate((BatchPsPara)object);
        }
        if (collection != null && collection.size() > 0) {
            object = new BatchPsPara(string);
            for (String string2 : collection) {
                pSArgs = new PSArgs();
                pSArgs.addLongArg(l);
                pSArgs.addStringArg(string2);
                ((BatchPsPara)object).putArgs(pSArgs);
            }
            defaultContext.getDBManager().executeUpdate((BatchPsPara)object);
        }
    }

    @Override
    public void saveDictEmptRights(DefaultContext defaultContext, boolean bl, long l, String string, DictRights object) throws Throwable {
        if (!object.hasEmptRights() && !object.hasAllRights()) {
            return;
        }
        object = defaultContext.getVE().getMetaFactory().getDataObject(string).getMainTable().getBindingDBTableName();
        object = (String)object + "_OR";
        String string2 = "delete from " + (String)object + " where OperatorID = ? and DictID = ?";
        defaultContext.getDBManager().execPrepareUpdate(string2, l, 0);
        if (bl && !this.loadDictRights(defaultContext, l, string).hasAllRights()) {
            String string3 = "insert into " + (String)object + "(OperatorID, DictID) values(?, ?)";
            defaultContext.getDBManager().execPrepareUpdate(string3, l, 0);
        }
    }

    public Boolean checkIsAdmin(IDBManager iDBManager, Long l) throws Throwable {
        String string = "select b.oid, b.isAdmin from SYS_OperatorRole a left join sys_role b on b.oid=a.Role where a.soid = ?";
        if ((iDBManager = iDBManager.execPrepareQuery(string, l)) != null && !iDBManager.isEmpty()) {
            for (int k = 0; k < iDBManager.size(); ++k) {
                if (iDBManager.getInt(k, "IsAdmin") != 1) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}

