/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.redis;

import com.bokesoft.yes.common.util.StringUtil;
import java.util.Collections;
import java.util.UUID;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.params.SetParams;

public class SimpleJedisLockTool {
    private static final String SCRIPT_UNLOCK = "if redis.call('get',KEYS[1]) == ARGV[1] then return redis.call('del',KEYS[1])  else return 0 end";
    private static final String LOCK_SUCCESS = "OK";
    private static final Long UNLOCK_SUCCESS = 1L;
    private JedisCluster cluster;
    private JedisPool pool;
    private int dbIndex;

    public SimpleJedisLockTool(JedisPool jedisPool, int n) {
        this.pool = jedisPool;
        this.dbIndex = n;
    }

    public SimpleJedisLockTool(JedisCluster jedisCluster) {
        this.cluster = jedisCluster;
    }

    public String lock(String string, long l, long l2) {
        String string2 = UUID.randomUUID().toString();
        long l3 = System.currentTimeMillis() + l;
        while (System.currentTimeMillis() < l3) {
            Object object;
            JedisCommands jedisCommands = null;
            try {
                jedisCommands = this.getJedisCommands();
                object = SetParams.setParams().nx().px(l2);
                object = jedisCommands.set(string, string2, object);
            }
            finally {
                this.close(jedisCommands);
            }
            if (LOCK_SUCCESS.equals(object)) {
                return string2;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(interruptedException.getMessage(), interruptedException);
            }
        }
        return null;
    }

    private JedisCommands getJedisCommands() {
        if (this.cluster != null) {
            return this.cluster;
        }
        if (this.pool != null) {
            Jedis jedis = this.pool.getResource();
            if (this.dbIndex != 0) {
                jedis.select(this.dbIndex);
            }
            return jedis;
        }
        return null;
    }

    public boolean unLock(String string, String string2) {
        if (StringUtil.isBlankOrNull((String)string2)) {
            return false;
        }
        JedisCommands jedisCommands = null;
        try {
            Object object = null;
            jedisCommands = this.getJedisCommands();
            if (jedisCommands instanceof Jedis) {
                object = ((Jedis)jedisCommands).eval(SCRIPT_UNLOCK, Collections.singletonList(string), Collections.singletonList(string2));
            } else if (jedisCommands instanceof JedisCluster) {
                object = ((JedisCluster)jedisCommands).eval(SCRIPT_UNLOCK, Collections.singletonList(string), Collections.singletonList(string2));
            }
            boolean bl = UNLOCK_SUCCESS.equals(object);
            this.close(jedisCommands);
            return bl;
        }
        catch (Throwable throwable) {
            this.close(jedisCommands);
            throw throwable;
        }
    }

    private void close(JedisCommands jedisCommands) {
        if (jedisCommands == null) {
            return;
        }
        if (jedisCommands instanceof Jedis) {
            ((Jedis)jedisCommands).close();
        }
    }
}

