/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.redis;

import com.bokesoft.yes.common.util.SerializeUtil;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.redis.SimpleJedisLockTool;
import com.bokesoft.yes.tools.cache.ICacheCallback;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.nosql.Connection;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisSimpleConnection
implements Connection {
    private JedisPool pool;
    private int dbIndex;
    private String prefix;

    public RedisSimpleConnection(JedisPool jedisPool, int n, String string) {
        this.pool = jedisPool;
        this.dbIndex = n;
        this.prefix = string;
    }

    public Jedis getJedis() {
        Jedis jedis = null;
        if (this.pool != null) {
            jedis = this.pool.getResource();
        }
        if (this.dbIndex != 0) {
            jedis.select(this.dbIndex);
        }
        return jedis;
    }

    public JedisPool getJedisPool() {
        return this.pool;
    }

    public void destroy() {
        if (this.pool != null) {
            this.pool.destroy();
        }
    }

    private String realKey(String string) {
        String string2 = string;
        if (this.prefix != null && !this.prefix.isEmpty()) {
            string2 = this.prefix + string;
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(String string, String string2, Object object) {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            object = SerializeUtil.serialize((Object)object);
            object = Base64.getEncoder().encodeToString((byte[])object);
            jedis.hset(this.realKey(string), string2, (String)object);
            if (jedis == null) return;
        }
        catch (Throwable throwable) {
            if (jedis == null) throw throwable;
            jedis.close();
            throw throwable;
        }
        jedis.close();
    }

    @Override
    public Object getValue(String object, String string) {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            object = jedis.hget(this.realKey((String)object), string);
            if (object == null || ((String)object).isEmpty()) {
                return null;
            }
            object = SerializeUtil.unSerialize((byte[])Base64.getDecoder().decode((String)object));
            return object;
        }
    }

    @Override
    public boolean contains(String string, String string2) {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            boolean bl = jedis.hexists(this.realKey(string), string2);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void remove(String string, String string2) {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            jedis.hdel(this.realKey(string), new String[]{string2});
            if (jedis == null) return;
        }
        catch (Throwable throwable) {
            if (jedis == null) throw throwable;
            jedis.close();
            throw throwable;
        }
        jedis.close();
    }

    @Override
    public long size(String string) {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            long l = jedis.hlen(this.realKey(string));
            return l;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeAll(String string, List<String> iterator) {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            string = this.realKey(string);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                this.remove(string, string2);
            }
            if (jedis == null) return;
        }
        catch (Throwable throwable) {
            if (jedis == null) throw throwable;
            jedis.close();
            throw throwable;
        }
        jedis.close();
    }

    @Override
    public Set<String> getKeys(String object) {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            object = jedis.hkeys(this.realKey((String)object));
            return object;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void clear(String string) {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            jedis.del(string);
            if (jedis == null) return;
        }
        catch (Throwable throwable) {
            if (jedis == null) throw throwable;
            jedis.close();
            throw throwable;
        }
        jedis.close();
    }

    @Override
    public long incr(String string, String string2, long l, ICacheCallback iCacheCallback) {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            if (jedis.hget(string, string2) != null) {
                long l2 = jedis.hincrBy(string, string2, l);
                return l2;
            }
            String string3 = string + "_" + string2 + "_Lock";
            String string4 = null;
            SimpleJedisLockTool simpleJedisLockTool = null;
            try {
                simpleJedisLockTool = new SimpleJedisLockTool(this.pool, this.dbIndex);
                string4 = simpleJedisLockTool.lock(string3, 1800000L, 30000L);
                if (StringUtil.isBlankOrNull((String)string4)) {
                    throw new RuntimeException("\u52a0\u9501\u5931\u8d25. \u52a0\u9501\u7684 Key: ".concat(String.valueOf(string3)));
                }
                if (jedis.hget(string, string2) == null && iCacheCallback != null) {
                    Object object = iCacheCallback.call();
                    if (object == null) {
                        throw new RuntimeException("\u521d\u59cb\u503c(" + object + ")\u4e0d\u5408\u6cd5");
                    }
                    jedis.hset(string, string2, TypeConvertor.toString((Object)object));
                }
                simpleJedisLockTool.unLock(string3, string4);
            }
            catch (Throwable throwable) {
                try {
                    throw new RuntimeException(throwable.getMessage(), throwable);
                }
                catch (Throwable throwable2) {
                    if (simpleJedisLockTool != null) {
                        simpleJedisLockTool.unLock(string3, string4);
                    }
                    throw throwable2;
                }
            }
            long l3 = jedis.hincrBy(string, string2, l);
            return l3;
        }
    }
}

