/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.redis;

import com.bokesoft.yes.mid.redis.RedisClusterConnection;
import com.bokesoft.yes.mid.redis.RedisSimpleConnection;
import com.bokesoft.yes.mid.redis.a;
import com.bokesoft.yes.mid.util.PropertyUtil;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.nosql.Connection;
import com.bokesoft.yigo.mid.nosql.IConnectionFactory;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisConnectionFactory
implements IConnectionFactory {
    private Properties properties = null;
    private static ConcurrentHashMap<Integer, JedisCluster> clusterPools = new ConcurrentHashMap();
    private static ConcurrentHashMap<Integer, JedisPool> pools = new ConcurrentHashMap();

    public RedisConnectionFactory() {
        try {
            this.init();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private void init() throws Throwable {
        FileInputStream fileInputStream = PropertyUtil.readProperties("redis.properties");
        FileInputStream fileInputStream2 = null;
        if (fileInputStream != null) {
            block8: {
                try {
                    this.properties = new Properties();
                    this.properties.load(fileInputStream);
                    if (this.properties.containsKey("Cluster")) {
                        boolean bl = Boolean.parseBoolean(this.properties.getProperty("Cluster"));
                        if (bl) {
                            fileInputStream2 = PropertyUtil.readProperties("redis-cluster.properties");
                            this.properties = new Properties();
                            this.properties.load(fileInputStream2);
                        }
                        this.properties.setProperty("cluster", String.valueOf(bl));
                    }
                    if (fileInputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    if (fileInputStream2 != null) {
                        fileInputStream2.close();
                    }
                    throw throwable;
                }
                fileInputStream.close();
            }
            if (fileInputStream2 != null) {
                fileInputStream2.close();
                return;
            }
        }
    }

    @Override
    public Connection getConnection(Properties object) {
        object = Boolean.parseBoolean(((Properties)object).getProperty("cluster")) ? new RedisClusterConnection(this.getCluster((Properties)object), this.getPrefix((Properties)object)) : new RedisSimpleConnection(this.getPool((Properties)object), this.getDBIndex((Properties)object), this.getPrefix((Properties)object));
        return object;
    }

    @Override
    public Connection getConnection() {
        if (this.properties == null) {
            return null;
        }
        RedisConnectionFactory redisConnectionFactory = this;
        return redisConnectionFactory.getConnection(redisConnectionFactory.properties);
    }

    private int getDBIndex(Properties properties) {
        int n = 0;
        if (properties.containsKey("DBIndex")) {
            n = Integer.parseInt(properties.getProperty("DBIndex"));
        }
        return n;
    }

    private String getPrefix(Properties properties) {
        String string = null;
        if (properties.containsKey("Prefix")) {
            string = properties.getProperty("Prefix");
        }
        return string;
    }

    public JedisCluster getCluster(Properties properties) {
        if (properties == null) {
            throw new MidCoreException(36, MidCoreException.formatMessage(null, 36, new Object[0]));
        }
        int n = properties.hashCode();
        Object object = clusterPools.get(n);
        if (object == null) {
            object = Pattern.compile("^.+[:]\\d{1,5}\\s*$");
            HashSet<HostAndPort> hashSet = new HashSet<HostAndPort>();
            for (Object object2 : properties.keySet()) {
                if (!((String)object2).startsWith("address")) continue;
                String string = (String)properties.get(object2);
                if (!((Pattern)object).matcher(string).matches()) {
                    throw new IllegalArgumentException("ip \u6216 port \u4e0d\u5408\u6cd5");
                }
                String[] stringArray = string.split(":");
                HostAndPort hostAndPort = new HostAndPort(stringArray[0], Integer.parseInt(stringArray[1]));
                hashSet.add(hostAndPort);
            }
            int n2 = 0;
            if (properties.containsKey("timeout")) {
                n2 = Integer.parseInt(properties.getProperty("timeout"));
            }
            int n3 = 3000;
            if (properties.containsKey("soTimeout")) {
                n3 = Integer.parseInt(properties.getProperty("soTimeout"));
            }
            int n4 = 0;
            if (properties.containsKey("maxTotal")) {
                n4 = Integer.parseInt(properties.getProperty("maxTotal"));
            }
            int n5 = 0;
            if (properties.containsKey("maxIdle")) {
                n5 = Integer.parseInt(properties.getProperty("maxIdle"));
            }
            int n6 = 0;
            if (properties.containsKey("minIdle")) {
                n6 = Integer.parseInt(properties.getProperty("minIdle"));
            }
            long l = -1L;
            if (properties.containsKey("maxWaitMillis")) {
                l = Long.parseLong(properties.getProperty("maxWaitMillis"));
            }
            boolean bl = false;
            if (properties.containsKey("blockWhenExhausted")) {
                bl = Boolean.parseBoolean(properties.getProperty("blockWhenExhausted"));
            }
            String string = null;
            if (properties.containsKey("passWord")) {
                string = properties.getProperty("passWord");
            }
            int n7 = 10;
            if (properties.containsKey("maxAttempts")) {
                n7 = Integer.parseInt(properties.getProperty("maxAttempts"));
            }
            properties = new GenericObjectPoolConfig();
            properties.setMaxTotal(n4);
            properties.setMaxIdle(n5);
            properties.setMinIdle(n6);
            properties.setMaxWaitMillis(l);
            properties.setBlockWhenExhausted(bl);
            object = new JedisCluster(hashSet, n2, n3, n7, string, (GenericObjectPoolConfig)properties);
            clusterPools.put(n, (JedisCluster)object);
        }
        return object;
    }

    public JedisPool getPool(Properties object) {
        if (object == null) {
            throw new MidCoreException(36, MidCoreException.formatMessage(null, 36, new Object[0]));
        }
        int n = ((Properties)object).hashCode();
        JedisPool jedisPool = pools.get(n);
        if (jedisPool == null) {
            object = this.initConfig((Properties)object);
            jedisPool = new JedisPoolConfig();
            jedisPool.setMaxTotal(((a)object).a);
            jedisPool.setMaxIdle(((a)object).b);
            jedisPool.setMaxWaitMillis((long)((a)object).c);
            jedisPool = ((a)object).password != null && !((a)object).password.isEmpty() ? new JedisPool((GenericObjectPoolConfig)jedisPool, ((a)object).host, ((a)object).port, ((a)object).timeout, ((a)object).password) : new JedisPool((GenericObjectPoolConfig)jedisPool, ((a)object).host, ((a)object).port, ((a)object).timeout);
            pools.put(n, jedisPool);
        }
        return jedisPool;
    }

    private a initConfig(Properties properties) {
        String string;
        a a2 = new a();
        if (properties.containsKey("Host") && (string = properties.getProperty("Host")) != null && !string.isEmpty()) {
            a2.host = string;
        }
        if (properties.containsKey("Port") && (string = properties.getProperty("Port")) != null && !string.isEmpty()) {
            a2.port = Integer.parseInt(string);
        }
        if (properties.containsKey("PassWord") && (string = properties.getProperty("PassWord")) != null && !string.isEmpty()) {
            a2.password = string;
        }
        if (properties.containsKey("TimeOut") && (string = properties.getProperty("TimeOut")) != null && !string.isEmpty()) {
            a2.timeout = Integer.parseInt(string);
        }
        if (properties.containsKey("MaxActive") && (string = properties.getProperty("MaxActive")) != null && !string.isEmpty()) {
            a2.a = Integer.parseInt(string);
        }
        if (properties.containsKey("MaxIdle") && (string = properties.getProperty("MaxIdle")) != null && !string.isEmpty()) {
            a2.b = Integer.parseInt(string);
        }
        if (properties.containsKey("MaxWait") && (string = properties.getProperty("MaxWait")) != null && !string.isEmpty()) {
            a2.c = Integer.parseInt(string);
        }
        return a2;
    }
}

