/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.redis;

import com.bokesoft.yes.common.util.SerializeUtil;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.redis.SimpleJedisLockTool;
import com.bokesoft.yes.tools.cache.ICacheCallback;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.nosql.Connection;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import redis.clients.jedis.JedisCluster;

public class RedisClusterConnection
implements Connection {
    private JedisCluster cluster;
    private String prefix;

    public RedisClusterConnection(JedisCluster jedisCluster, String string) {
        this.cluster = jedisCluster;
        this.prefix = string;
    }

    public JedisCluster getJedisCluster() {
        return this.cluster;
    }

    private String realKey(String string) {
        String string2 = string;
        if (this.prefix != null && !this.prefix.isEmpty()) {
            string2 = this.prefix + string;
        }
        return string2;
    }

    @Override
    public void setValue(String string, String string2, Object object) {
        object = SerializeUtil.serialize((Object)object);
        object = Base64.getEncoder().encodeToString((byte[])object);
        this.cluster.hset(this.realKey(string), string2, (String)object);
    }

    @Override
    public Object getValue(String string, String string2) {
        if ((string = this.cluster.hget(this.realKey(string), string2)) == null || string.isEmpty()) {
            return null;
        }
        return SerializeUtil.unSerialize((byte[])Base64.getDecoder().decode(string));
    }

    @Override
    public boolean contains(String string, String string2) {
        return this.cluster.hexists(this.realKey(string), string2);
    }

    @Override
    public long size(String string) {
        return this.cluster.hlen(this.realKey(string));
    }

    @Override
    public void remove(String string, String string2) {
        this.cluster.hdel(this.realKey(string), new String[]{string2});
    }

    @Override
    public void removeAll(String string, List<String> object) {
        string = this.realKey(string);
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            this.remove(string, string2);
        }
    }

    @Override
    public Set<String> getKeys(String string) {
        return this.cluster.hkeys(this.realKey(string));
    }

    @Override
    public void clear(String string) {
        this.cluster.del(string);
    }

    @Override
    public long incr(String string, String string2, long l, ICacheCallback object) {
        if (this.cluster.hget(string = this.getRedisKey(string), string2) != null) {
            return this.cluster.hincrBy(string, string2, l);
        }
        String string3 = string + "_" + string2 + "_Lock";
        String string4 = null;
        SimpleJedisLockTool simpleJedisLockTool = null;
        try {
            simpleJedisLockTool = new SimpleJedisLockTool(this.cluster);
            string4 = simpleJedisLockTool.lock(string3, 1800000L, 30000L);
            if (StringUtil.isBlankOrNull((String)string4)) {
                throw new RuntimeException("\u52a0\u9501\u5931\u8d25. \u52a0\u9501\u7684 Key: ".concat(String.valueOf(string3)));
            }
            if (this.cluster.hget(string, string2) == null && object != null) {
                if ((object = object.call()) == null) {
                    throw new RuntimeException("\u521d\u59cb\u503c(" + object + ")\u4e0d\u5408\u6cd5");
                }
                this.cluster.hset(string, string2, TypeConvertor.toString((Object)object));
            }
            simpleJedisLockTool.unLock(string3, string4);
        }
        catch (Throwable throwable) {
            try {
                throw new RuntimeException(throwable.getMessage(), throwable);
            }
            catch (Throwable throwable2) {
                if (simpleJedisLockTool != null) {
                    simpleJedisLockTool.unLock(string3, string4);
                }
                throw throwable2;
            }
        }
        return this.cluster.hincrBy(string, string2, l);
    }

    private String getRedisKey(String string) {
        return "{ERP}:".concat(string);
    }
}

