/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.document;

import com.bokesoft.yes.mid.document.util.SystemTopicUtil;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.oid.IOIDAllocator;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.document.Document;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DocumentProcess {
    private MetaDataObject dataObject = null;
    private Document document = null;

    public DocumentProcess(MetaDataObject metaDataObject, Document document) {
        this.dataObject = metaDataObject;
        this.document = document;
    }

    public void process(DefaultContext defaultContext, IOIDAllocator iOIDAllocator) throws Throwable {
        DocumentProcess.processDoc(defaultContext, this.dataObject, iOIDAllocator, this.document);
    }

    public static void processDoc(DefaultContext defaultContext, MetaDataObject metaDataObject, IOIDAllocator iOIDAllocator, Document document) throws Throwable {
        long l = document.getOID();
        Date date = new Date();
        if (document.getDocumentType() == 1 && metaDataObject.getSecondaryType() != 6 && metaDataObject.getSecondaryType() != 8) {
            DocumentProcess.processMainTable(defaultContext, metaDataObject, document, iOIDAllocator, date);
            if (l <= 0L) {
                l = iOIDAllocator.applyNewOID();
                document.setOID(l);
            }
        }
        boolean bl = metaDataObject.getMainTable() == null || metaDataObject.getSecondaryType() == 6 || metaDataObject.getSecondaryType() == 8;
        long l2 = defaultContext.getClusterid();
        for (MetaTable metaTable : metaDataObject.getTableCollection()) {
            boolean bl2;
            metaDataObject = document.get(metaTable.getKey());
            if (metaDataObject == null || !metaTable.isPersist() || metaTable.isHidden()) continue;
            boolean bl3 = bl2 = metaTable.getCLUSTERIDColumn() != null && l2 > 0L;
            if (metaTable.getLevelID() > 2) {
                DocumentProcess.processTableBelow2(defaultContext, document.get(metaTable.getParentKey()), (DataTable)metaDataObject, metaTable, iOIDAllocator, l, bl2, l2, document.getVERID(), date);
                continue;
            }
            DocumentProcess.processTable(defaultContext, (DataTable)metaDataObject, metaTable, iOIDAllocator, bl, l, bl2, l2, document.getVERID(), date);
        }
    }

    private static void processMainTable(DefaultContext defaultContext, MetaDataObject metaDataObject, Document object, IOIDAllocator object2, Date date) throws Throwable {
        String string = metaDataObject.getMainTableKey();
        MetaTable metaTable = metaDataObject.getMetaTable(string);
        if ((string = object.get(string)) == null || string.isEmpty()) {
            return;
        }
        if (defaultContext.getOption("Feedback") != null) {
            return;
        }
        string.first();
        DocumentProcess.updateModify(defaultContext, (DataTable)string, metaTable, date);
        if (!object.isNew() || string.getState(0) != 1) {
            return;
        }
        if (metaTable.getNOColumn() != null && ((object = string.getString(0, "NO")) == null || ((String)object).length() == 0)) {
            object = metaDataObject.getCustomNoPrefix();
            if (object != null && !((String)object).isEmpty()) {
                object = (String)defaultContext.getMidParser().eval(0, (String)object);
            } else {
                object = metaDataObject.getNoPrefix();
                if (((String)object).isEmpty()) {
                    object = metaDataObject.getKey().toUpperCase();
                }
                Date date2 = new Date();
                String string2 = new SimpleDateFormat("yyyyMMdd").format(date2);
                object = (String)object + string2;
            }
            int n = object2.applyNewSequenceID(metaDataObject.getKey(), (String)object, defaultContext.getFormKey());
            object2 = "";
            for (int k = 0; k < metaDataObject.getZeroPrefix() - String.valueOf(n).length(); ++k) {
                object2 = (String)object2 + "0";
            }
            object2 = (String)object2 + n;
            string.setString(0, "NO", (String)object + (String)object2);
        }
        DocumentProcess.updateCreate(defaultContext, (DataTable)string, metaTable, date);
    }

    private static void updateCodeField(DefaultContext object, DataTable dataTable, MetaTable metaTable) throws Throwable {
        if (metaTable.containsKey("Code") && (object = dataTable.getString("Code")) != null && !((String)object).isEmpty() && !((String)object).toUpperCase().equals(object)) {
            dataTable.setString("Code", ((String)object).toUpperCase());
        }
    }

    private static void processTable(DefaultContext defaultContext, DataTable dataTable, MetaTable metaTable, IOIDAllocator iOIDAllocator, boolean bl, long l, boolean bl2, long l2, Integer n, Date date) throws Throwable {
        boolean bl3 = !bl && metaTable.getTableMode() == 0;
        dataTable.beforeFirst();
        DataTableMetaData dataTableMetaData = dataTable.getMetaData();
        int n2 = dataTableMetaData.findColumnIndexByKey("OID");
        int n3 = dataTableMetaData.findColumnIndexByKey("SOID");
        int n4 = dataTableMetaData.findColumnIndexByKey("VERID");
        int n5 = dataTableMetaData.findColumnIndexByKey("DVERID");
        int n6 = -1;
        if (bl2) {
            n6 = dataTableMetaData.findColumnIndexByKey("ClusterID");
        }
        int n7 = dataTableMetaData.findColumnIndexByKey("SVERID");
        while (dataTable.next()) {
            if (dataTable.getState() == 1) {
                Long l3 = dataTable.getLong(n2);
                Long l4 = dataTable.getLong(n3);
                if (l3 == null || l3 <= 0L) {
                    l3 = bl3 ? l : iOIDAllocator.applyNewOID();
                    dataTable.setLong(n2, l3);
                }
                if (l4 == null || l4 <= 0L) {
                    if (bl) {
                        dataTable.setLong(n3, l3);
                    } else {
                        dataTable.setLong(n3, Long.valueOf(l));
                    }
                }
                dataTable.setInt(n4, Integer.valueOf(0));
                dataTable.setInt(n5, Integer.valueOf(0));
                if (bl2 && ((l3 = dataTable.getLong(n6)) == null || l3 <= 0L)) {
                    dataTable.setLong(n6, Long.valueOf(l2));
                }
                if (n7 >= 0) {
                    dataTable.setInt(n7, n);
                }
                DocumentProcess.updateCreate(defaultContext, dataTable, metaTable, date);
            }
            if (dataTable.getState() != 1 && dataTable.getState() != 2) continue;
            DocumentProcess.updateModify(defaultContext, dataTable, metaTable, date);
        }
    }

    private static void processTableBelow2(DefaultContext defaultContext, DataTable dataTable, DataTable dataTable2, MetaTable metaTable, IOIDAllocator iOIDAllocator, long l, boolean bl, long l2, Integer n, Date date) throws Throwable {
        dataTable2.beforeFirst();
        DataTableMetaData dataTableMetaData = dataTable2.getMetaData();
        int n2 = dataTableMetaData.findColumnIndexByKey("OID");
        int n3 = dataTableMetaData.findColumnIndexByKey("SOID");
        int n4 = dataTableMetaData.findColumnIndexByKey("POID");
        int n5 = dataTableMetaData.findColumnIndexByKey("SVERID");
        while (dataTable2.next()) {
            if (dataTable2.getState() == 1) {
                Long l3 = dataTable2.getLong(n2);
                Long l4 = dataTable2.getLong(n3);
                Long l5 = dataTable2.getLong(n4);
                if (l3 == null || l3 <= 0L) {
                    dataTable2.setLong("OID", Long.valueOf(iOIDAllocator.applyNewOID()));
                }
                if (l4 == null || l4 <= 0L) {
                    dataTable2.setLong("SOID", Long.valueOf(l));
                }
                dataTable2.setInt("VERID", Integer.valueOf(0));
                dataTable2.setInt("DVERID", Integer.valueOf(0));
                if (bl && ((l3 = dataTable2.getLong("ClusterID")) == null || l3 <= 0L)) {
                    dataTable2.setLong("ClusterID", Long.valueOf(l2));
                }
                if (l5 == null || l5 <= 0L) {
                    dataTable.setBookmark(dataTable2.getParentBookmark());
                    l3 = dataTable.getLong("OID");
                    dataTable2.setLong("POID", l3);
                }
                if (n5 >= 0) {
                    dataTable2.setInt(n5, n);
                }
                DocumentProcess.updateCreate(defaultContext, dataTable2, metaTable, date);
            }
            if (dataTable2.getState() != 1 && dataTable2.getState() != 2) continue;
            DocumentProcess.updateModify(defaultContext, dataTable2, metaTable, date);
        }
    }

    private static void updateCreate(DefaultContext defaultContext, DataTable dataTable, MetaTable metaTable, Date date) {
        if (metaTable.getCREATETIMEColumn() != null && SystemTopicUtil.check(defaultContext, "CreateTime")) {
            dataTable.setDateTime("CreateTime", date);
        }
        if (metaTable.getBILLDATEColumn() != null && dataTable.getObject("BillDate") == null && SystemTopicUtil.check(defaultContext, "BillDate")) {
            dataTable.setDateTime("BillDate", date);
        }
        if (metaTable.getCreatorColumn() != null && defaultContext.getUserID() > 0L && SystemTopicUtil.check(defaultContext, "Creator")) {
            dataTable.setLong("Creator", Long.valueOf(defaultContext.getUserID()));
        }
    }

    private static void updateModify(DefaultContext defaultContext, DataTable dataTable, MetaTable metaTable, Date date) {
        if (!defaultContext.isUpdateModify()) {
            return;
        }
        if (metaTable.getModifierColumn() != null && defaultContext.getUserID() > 0L && SystemTopicUtil.check(defaultContext, "Modifier")) {
            dataTable.setLong("Modifier", Long.valueOf(defaultContext.getUserID()));
        }
        if (metaTable.getModifytimeColumn() != null && SystemTopicUtil.check(defaultContext, "ModifyTime")) {
            dataTable.setDateTime("ModifyTime", date);
        }
    }
}

