/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dict;

import com.bokesoft.yes.mid.cache.ThreadVersionCacheMgr;
import com.bokesoft.yes.struct.dict.ItemTableMetaDatas;
import com.bokesoft.yes.tools.dic.item.ICache;
import com.bokesoft.yigo.struct.dict.Item;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SyncDictItemCache
implements ICache {
    private Map<String, Long> curVersions = new HashMap<String, Long>();
    private Map<Long, Item> items = new ConcurrentHashMap<Long, Item>();
    private String[] sortColumns = null;
    private Item rootItem = null;
    private String itemKey = null;

    public SyncDictItemCache(ItemTableMetaDatas object) {
        this.itemKey = object.getItemKey();
        this.rootItem = new Item(object.getItemKey(), 0L);
        object = object.getMainTable().getSortColumns();
        this.sortColumns = ((String)object).split(",");
    }

    public Item getItemByID(long l) throws Throwable {
        if (!this.checkVersion(l)) {
            return null;
        }
        if (l == 0L) {
            return this.rootItem;
        }
        return this.items.get(l);
    }

    public List<Item> getItems(List<Long> object) throws Throwable {
        ArrayList<Item> arrayList = new ArrayList<Item>();
        object = object.iterator();
        while (object.hasNext()) {
            long l = (Long)object.next();
            Item item = this.getItemByID(l);
            if (item == null) continue;
            arrayList.add(item);
        }
        return arrayList;
    }

    public void addItem(Item item) throws Throwable {
        if (item != null) {
            this.items.put(item.getID(), item);
        }
    }

    public void addItems(List<Item> list) throws Throwable {
        if (list != null && list.size() > 0) {
            for (int k = 0; k < list.size(); ++k) {
                Item item = list.get(k);
                this.items.put(item.getID(), item);
            }
        }
    }

    public void reomveItem(long l) throws Throwable {
        this.items.remove(l);
    }

    public boolean existItem(long l) throws Throwable {
        if (!this.checkVersion(l)) {
            return false;
        }
        return this.items.containsKey(l);
    }

    public Item locate(String string, Object object) throws Throwable {
        return null;
    }

    public String[] getSortColumns(String string) {
        return this.sortColumns;
    }

    public int getLayerLevel(String string) {
        return 0;
    }

    public void clear() {
        this.items.clear();
    }

    public long update(Long l) {
        try {
            l = this.curVersions.get(ThreadVersionCacheMgr.DictGlobalVersion + "_" + this.itemKey);
            if (l == null) {
                l = 0L;
            }
            Long l2 = ThreadVersionCacheMgr.getVersion(ThreadVersionCacheMgr.DictGlobalVersion + "_" + this.itemKey);
            long l3 = Math.max(l, l2) + 1L;
            this.curVersions.put(ThreadVersionCacheMgr.DictGlobalVersion + "_" + this.itemKey, l3);
            ThreadVersionCacheMgr.updataVersion(ThreadVersionCacheMgr.DictGlobalVersion + "_" + this.itemKey, l3);
            long l4 = l3;
            return l4;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.curVersions.remove(ThreadVersionCacheMgr.DictGlobalVersion + "_" + this.itemKey);
            this.items.clear();
        }
        finally {
            this.items.clear();
        }
        return -1L;
    }

    private boolean checkVersion(Long l) {
        l = this.curVersions.get(ThreadVersionCacheMgr.DictGlobalVersion + "_" + this.itemKey);
        if (l == null) {
            l = 0L;
        }
        Long l2 = ThreadVersionCacheMgr.getVersion(ThreadVersionCacheMgr.DictGlobalVersion + "_" + this.itemKey);
        boolean bl = true;
        if (l2 < l) {
            bl = true;
        } else if (l2 == l) {
            bl = true;
        } else if (l2 > l) {
            bl = false;
            this.items.clear();
            this.curVersions.put(ThreadVersionCacheMgr.DictGlobalVersion + "_" + this.itemKey, l2);
        }
        return bl;
    }
}

