/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.authority.util;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.authority.AuthorityProviderFactory;
import com.bokesoft.yes.mid.authority.IAuthorityProvider;
import com.bokesoft.yes.mid.authority.util.AuthorityParaUtil;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceEvent;
import com.bokesoft.yigo.mid.base.RightsContext;
import com.bokesoft.yigo.mid.rights.RightsObject;
import com.bokesoft.yigo.struct.document.Document;
import java.util.List;
import org.json.JSONObject;

public class AuthorityCheckUtil {
    public static JSONObject getEntry(DefaultContext defaultContext, JSONObject jSONObject) throws Throwable {
        IAuthorityProvider iAuthorityProvider = AuthorityCheckUtil.getProvider();
        if (iAuthorityProvider == null) {
            return jSONObject;
        }
        return iAuthorityProvider.getEntry(defaultContext, jSONObject);
    }

    public static RightsObject getFormRights(RightsContext object, IServiceEvent iServiceEvent) throws Throwable {
        IAuthorityProvider iAuthorityProvider = AuthorityCheckUtil.getProvider();
        if (iAuthorityProvider == null) {
            object = new RightsObject(object.getFormKey());
            object.setAllOptRights(true);
            return object;
        }
        return iAuthorityProvider.getFormRights((RightsContext)object, iServiceEvent);
    }

    public static void checkBeforeSave(DefaultContext object) throws Throwable {
        IAuthorityProvider iAuthorityProvider = AuthorityCheckUtil.getProvider();
        if (iAuthorityProvider == null) {
            return;
        }
        String string = AuthorityParaUtil.getFCode((DefaultContext)object);
        String string2 = AuthorityParaUtil.getActivity((DefaultContext)object);
        if (StringUtil.isBlankOrNull((String)string)) {
            return;
        }
        if (!StringUtil.isBlankOrNull((String)(object = iAuthorityProvider.authorityCheck((DefaultContext)object, string, string2)))) {
            throw new RuntimeException((String)object);
        }
    }

    public static void checkBeforeDelete(DefaultContext object) throws Throwable {
        IAuthorityProvider iAuthorityProvider = AuthorityCheckUtil.getProvider();
        if (iAuthorityProvider == null) {
            return;
        }
        String string = AuthorityParaUtil.getFCode((DefaultContext)object);
        String string2 = AuthorityParaUtil.getActivity((DefaultContext)object);
        if (StringUtil.isBlankOrNull((String)string)) {
            return;
        }
        if (!StringUtil.isBlankOrNull((String)(object = iAuthorityProvider.authorityCheck((DefaultContext)object, string, string2)))) {
            throw new RuntimeException((String)object);
        }
    }

    public static void checkAfterLoad(DefaultContext object, Document document) throws Throwable {
        IAuthorityProvider iAuthorityProvider = AuthorityCheckUtil.getProvider();
        if (iAuthorityProvider == null) {
            return;
        }
        String string = AuthorityParaUtil.getFCode((DefaultContext)object);
        String string2 = AuthorityParaUtil.getActivity((DefaultContext)object);
        if (StringUtil.isBlankOrNull((String)string)) {
            return;
        }
        if (!StringUtil.isBlankOrNull((String)(object = iAuthorityProvider.authorityCheck((DefaultContext)object, string, string2))) && document.getMetaDataObject().getLoadRightsType() == 1) {
            throw new RuntimeException((String)object);
        }
    }

    public static String checkOperation(DefaultContext defaultContext) throws Throwable {
        IAuthorityProvider iAuthorityProvider = AuthorityCheckUtil.getProvider();
        if (iAuthorityProvider == null) {
            return null;
        }
        String string = AuthorityParaUtil.getFCode(defaultContext);
        String string2 = AuthorityParaUtil.getActivity(defaultContext);
        if (StringUtil.isBlankOrNull((String)string)) {
            return null;
        }
        return iAuthorityProvider.authorityCheck(defaultContext, string, string2);
    }

    public static String getTableAuthoritySql(DefaultContext object, MetaTable metaTable, PrepareSQL prepareSQL) throws Throwable {
        IAuthorityProvider iAuthorityProvider = AuthorityCheckUtil.getProvider();
        if (iAuthorityProvider == null) {
            return "";
        }
        String string = AuthorityParaUtil.getFCode((DefaultContext)object);
        String string2 = AuthorityParaUtil.getActivity((DefaultContext)object);
        if (StringUtil.isBlankOrNull((String)string)) {
            return "";
        }
        object = iAuthorityProvider.tableAuthoritySql((DefaultContext)object, string, string2, ((DefaultContext)object).getFormKey(), metaTable);
        prepareSQL.addAllValue(((SqlString)object).getParameterList());
        return ((SqlString)object).getSql();
    }

    public static PrepareSQL dictAuthoritySql(DefaultContext object, String string, String string2, int n) throws Throwable {
        IAuthorityProvider iAuthorityProvider = AuthorityCheckUtil.getProvider();
        if (iAuthorityProvider == null) {
            return null;
        }
        String string3 = AuthorityParaUtil.getFCode((DefaultContext)object);
        AuthorityParaUtil.getActivity((DefaultContext)object);
        if (StringUtil.isBlankOrNull((String)string3)) {
            return null;
        }
        DefaultContext defaultContext = object;
        object = iAuthorityProvider.dictAuthoritySql(defaultContext, AuthorityParaUtil.getFCode(defaultContext), AuthorityParaUtil.getActivity((DefaultContext)object), string, string2, n);
        string = new PrepareSQL();
        string.setSQL(((SqlString)object).getSql());
        string.addAllValue(((SqlString)object).getParameterList());
        return string;
    }

    public static Boolean hasDictRights(DefaultContext defaultContext, String string, long l) throws Throwable {
        IAuthorityProvider iAuthorityProvider = AuthorityCheckUtil.getProvider();
        if (iAuthorityProvider == null) {
            return Boolean.TRUE;
        }
        String string2 = AuthorityParaUtil.getFCode(defaultContext);
        String string3 = AuthorityParaUtil.getActivity(defaultContext);
        if (StringUtil.isBlankOrNull((String)string2)) {
            return Boolean.TRUE;
        }
        return iAuthorityProvider.dictIdCheck(defaultContext, string2, string3, string, l);
    }

    public static boolean isAuthorityEnabled() {
        IAuthorityProvider iAuthorityProvider = AuthorityCheckUtil.getProvider();
        if (iAuthorityProvider == null) {
            return false;
        }
        return iAuthorityProvider.isAuthorityEnabled();
    }

    public static boolean hasEntryRights(DefaultContext defaultContext, String string) {
        return true;
    }

    public static List<Long> getHasRightsDictIDs(DefaultContext defaultContext, String string) {
        throw new RuntimeException("\u6839\u636eItemKey,\u83b7\u53d6\u5f53\u524d\u754c\u9762\u6709\u6743\u9650\u7684\u5b57\u5178ID\u503c\u8303\u56f4 \u672a\u5b9e\u73b0");
    }

    private static IAuthorityProvider getProvider() {
        return AuthorityProviderFactory.getAuthorityProvider();
    }
}

