/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.util;

import com.bokesoft.yigo.meta.annotation.DataElementAttribute;
import com.bokesoft.yigo.meta.annotation.DomainAttribute;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetaAnnotationUtil {
    private static Map<String, List<Field>> fieldCache = new HashMap<String, List<Field>>();
    private static Map<String, Method> methodCache = new HashMap<String, Method>();

    public static void mergeProperty(Object instance, MetaDomain ref) {
        Class<?> clazz = instance.getClass();
        String key = clazz.getName() + "_MetaDomain";
        List<Field> list = fieldCache.get(key);
        if (list == null) {
            list = new ArrayList<Field>();
            while (clazz != null) {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    DomainAttribute annotation = field.getAnnotation(DomainAttribute.class);
                    if (annotation == null) continue;
                    list.add(field);
                }
                clazz = clazz.getSuperclass();
            }
            fieldCache.put(key, list);
        }
        clazz = instance.getClass();
        for (Field field : list) {
            DomainAttribute annotation = field.getAnnotation(DomainAttribute.class);
            MetaAnnotationUtil.doMerge(clazz, instance, ref, field.getName(), annotation.refName(), annotation.allowNull());
        }
    }

    public static void mergeProperty(Object instance, MetaDataElement ref) {
        Class<?> clazz = instance.getClass();
        String key = clazz.getName() + "_MetaDataElement";
        List<Field> list = fieldCache.get(key);
        if (list == null) {
            list = new ArrayList<Field>();
            while (clazz != null) {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    DataElementAttribute annotation = field.getAnnotation(DataElementAttribute.class);
                    if (annotation == null) continue;
                    list.add(field);
                }
                clazz = clazz.getSuperclass();
            }
            fieldCache.put(key, list);
        }
        clazz = instance.getClass();
        for (Field field : list) {
            DataElementAttribute annotation = field.getAnnotation(DataElementAttribute.class);
            int overwriteType = annotation.overwriteType();
            if (overwriteType == 2) {
                Object old = null;
                try {
                    old = MetaAnnotationUtil.getFieldValue(field.getName(), clazz, instance);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                if (old != null && !"".equals(old)) continue;
                MetaAnnotationUtil.doMerge(clazz, instance, ref, field.getName(), annotation.refName(), annotation.allowNull());
                continue;
            }
            if (overwriteType == 3) {
                throw new RuntimeException("mergeProperty merge not impl");
            }
            MetaAnnotationUtil.doMerge(clazz, instance, ref, field.getName(), annotation.refName(), annotation.allowNull());
        }
    }

    private static void doMerge(Class<?> instanceClazz, Object instance, Object ref, String srcFieldName, String refFieldName, boolean allowNull) {
        Object v = null;
        try {
            if (refFieldName == null || refFieldName.isEmpty()) {
                refFieldName = srcFieldName;
            }
            v = MetaAnnotationUtil.getFieldValue(refFieldName, ref.getClass(), ref);
            if (allowNull || v != null) {
                MetaAnnotationUtil.setFieldValue(instanceClazz, instance, srcFieldName, v);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static Object getFieldValue(String fieldName, Class<?> clazz, Object ref) throws Throwable {
        Method getMethod = MetaAnnotationUtil.getReadMethod(fieldName, clazz);
        Object v = null;
        if (getMethod == null) {
            throw new RuntimeException("Field:" + fieldName + " getValue is error");
        }
        v = getMethod.invoke(ref, new Object[0]);
        return v;
    }

    private static Method getReadMethod(String fieldName, Class<?> clazz) throws Throwable {
        String key = clazz.getName() + "_rm_" + fieldName;
        Method m = methodCache.get(key);
        if (m == null) {
            PropertyDescriptor pd = new PropertyDescriptor(fieldName, clazz);
            m = pd.getReadMethod();
            methodCache.put(key, m);
        }
        return m;
    }

    private static void setFieldValue(Class<?> instanceClazz, Object instance, String fieldName, Object v) throws Throwable {
        Method setMethod = MetaAnnotationUtil.getWriteMethod(fieldName, instanceClazz);
        if (setMethod == null) {
            throw new RuntimeException("Field:" + fieldName + " setValue is error");
        }
        setMethod.invoke(instance, v);
    }

    private static Method getWriteMethod(String fieldName, Class<?> clazz) throws Throwable {
        String key = clazz.getName() + "_wm_" + fieldName;
        Method m = methodCache.get(key);
        if (m == null) {
            PropertyDescriptor pd = new PropertyDescriptor(fieldName, clazz);
            m = pd.getWriteMethod();
            methodCache.put(key, m);
        }
        return m;
    }
}

