/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.setting;

import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.setting.MetaBPMMColumn;
import java.util.LinkedList;

public class MetaBPMMTable
extends GenericKeyCollection<MetaBPMMColumn> {
    public static final String TAG_NAME = "Table";
    private Boolean activateMigration = true;
    private boolean inited = false;

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(IMetaFactory metaFactory) throws Throwable {
        if (!this.inited) {
            MetaBPMMTable metaBPMMTable = this;
            synchronized (metaBPMMTable) {
                if (!this.inited) {
                    MetaDataObject dataObject = metaFactory.getDataObject("BPM_Migration");
                    if (dataObject != null) {
                        this.join(dataObject);
                    }
                    this.inited = true;
                }
            }
        }
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    public Boolean isActivateMigration() {
        return this.activateMigration;
    }

    public void setActivateMigration(Boolean activateMigration) {
        this.activateMigration = activateMigration;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        MetaBPMMColumn resultMetaObject = null;
        if ("Column".equals(tagName)) {
            resultMetaObject = new MetaBPMMColumn();
            resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
            this.add(resultMetaObject);
        }
        return resultMetaObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaBPMMTable();
    }

    public void join(MetaDataObject dataObject) {
        MetaTable ttable = dataObject.getTable(dataObject.getMainTableKey());
        if (ttable != null) {
            for (MetaColumn column : ttable) {
                if (this.containsKey(column.getKey()) || SystemField.isSystemField((String)column.getKey())) continue;
                MetaBPMMColumn c = new MetaBPMMColumn();
                c.setCaption(column.getCaption());
                c.setKey(column.getKey());
                c.setDataType(column.getDataType());
                c.setDBColumnName(column.getDBColumnName());
                c.setDefaultValue(column.getDefaultValue());
                c.setLength(column.getLength());
                c.setPrecision(column.getPrecision());
                c.setScale(column.getScale());
                this.add(c);
            }
        }
    }

    public boolean isInited() {
        return this.inited;
    }

    public void setInited(boolean inited) {
        this.inited = inited;
    }
}

