/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.process;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.process.MetaDataObjectTemplateProcess;
import com.bokesoft.yes.meta.process.MetaDataObjectTemplateUtil;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaExtend;
import com.bokesoft.yigo.meta.common.MetaExtendCollection;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.common.MetaQuery;
import com.bokesoft.yigo.meta.common.MetaQueryCollection;
import com.bokesoft.yigo.meta.common.MetaVar;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.MetaBody;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormPara;
import com.bokesoft.yigo.meta.form.MetaFormParaCollection;
import com.bokesoft.yigo.meta.form.MetaUICheckRule;
import com.bokesoft.yigo.meta.form.MetaUICheckRuleCollection;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;
import com.bokesoft.yigo.meta.form.component.MetaEmbedVarCollection;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRowCollection;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.util.MetaUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public class MetaFormTemplateProcess {
    private IMetaFactory metaFactory = null;
    private MetaForm metaForm = null;
    private StringHashMap<MetaComponent> comsMap = null;
    private LinkedList<MetaComponent> embedArray = new LinkedList();

    public MetaFormTemplateProcess(IMetaFactory metaFactory, MetaForm metaForm) {
        this.metaFactory = metaFactory;
        this.metaForm = metaForm;
    }

    public void process() throws Throwable {
        MetaDataSource dataSource;
        if (this.metaForm.getFormType() == 7 || this.metaForm.getFormType() == 8) {
            return;
        }
        MetaBody metaBody = this.metaForm.getMetaBody();
        if (metaBody != null) {
            Iterator it = metaBody.iterator();
            MetaComponent metaComponent = null;
            while (it.hasNext()) {
                MetaBlock metaBlock;
                MetaComponent metaRoot;
                metaComponent = (MetaComponent)it.next();
                if (metaComponent.isPanel()) {
                    this.processPanel((MetaPanel)metaComponent);
                    continue;
                }
                if (metaComponent.getControlType() != 20000 || !(metaRoot = (metaBlock = (MetaBlock)metaComponent).getRoot()).isPanel()) continue;
                this.processPanel((MetaPanel)metaRoot);
            }
        }
        if ((dataSource = this.metaForm.getDataSource()) != null) {
            MetaDataObject dataObject = dataSource.getDataObject();
            String refObjectKey = dataSource.getRefObjectKey();
            if (dataObject != null && (refObjectKey == null || refObjectKey.isEmpty())) {
                MetaDataObjectTemplateProcess dataObjectProcess = new MetaDataObjectTemplateProcess(this.metaFactory, dataObject);
                dataObjectProcess.process();
            }
        }
    }

    private void buildMap() {
        this.comsMap = StringHashMap.newInstance();
        MetaBody metaBody = this.metaForm.getMetaBody();
        Stack<Object> stack = new Stack<Object>();
        int size = metaBody.size();
        for (int i = 0; i < size; ++i) {
            stack.push(metaBody.get(i));
        }
        MetaComponent meta = null;
        while (!stack.isEmpty()) {
            meta = (MetaComponent)stack.pop();
            if (meta.needCheckExtend()) {
                this.comsMap.put((Object)meta.getKey(), (Object)meta);
            }
            int size2 = meta.getComponentCount();
            for (int i = 0; i < size2; ++i) {
                stack.add(meta.getComponent(i));
            }
        }
    }

    private void checkTemplate(MetaPanel metaPanel) {
        Iterator<MetaComponent> it = metaPanel.iteratorComponent();
        MetaComponent meta1 = null;
        MetaComponent meta2 = null;
        MetaComponent embed2 = null;
        MetaPanel metaPanel1 = null;
        Iterator itr = null;
        ArrayList<MetaComponent> delList = new ArrayList<MetaComponent>();
        while (it.hasNext()) {
            meta1 = it.next();
            if (meta1.isExtend().booleanValue()) {
                meta2 = (MetaComponent)this.comsMap.get((Object)meta1.getKey());
                if (meta2 == null) {
                    for (MetaComponent embed2 : this.embedArray) {
                        if (!embed2.isPanel() || (meta2 = this.findComponent(metaPanel1 = (MetaPanel)embed2, meta1.getKey())) == null) continue;
                        delList.add(meta1);
                        break;
                    }
                } else {
                    delList.add(meta1);
                }
            } else {
                for (MetaComponent embed2 : this.embedArray) {
                    if (!embed2.isPanel() || (meta2 = this.findComponent(metaPanel1 = (MetaPanel)embed2, meta1.getKey())) == null || !meta2.isExtend().booleanValue()) continue;
                    metaPanel1.removeComponent(meta2);
                    break;
                }
            }
            if (!meta1.isPanel()) continue;
            this.checkTemplate((MetaPanel)meta1);
        }
        it = delList.iterator();
        while (it.hasNext()) {
            metaPanel.removeComponent(it.next());
        }
    }

    private void processPanel(MetaPanel metaPanel) throws Throwable {
        Iterator<MetaComponent> it = metaPanel.iteratorComponent();
        MetaComponent metaComponent2 = null;
        ArrayList<MetaComponent> newTemplateComponentArray = null;
        while (it.hasNext()) {
            MetaSubDetail metaSubDetail;
            MetaComponent root;
            metaComponent2 = it.next();
            if (metaComponent2.getControlType() == 253) {
                MetaUICheckRuleCollection metaUICheckRuleCollection;
                MetaExtendCollection metaExtendCollection;
                MetaQueryCollection metaQueryCollection;
                MetaFormParaCollection metaFormParaCollection;
                MetaMacroCollection metaMacroCollection;
                MetaDataObject sourceDataObject;
                String rootKey;
                MetaForm metaForm;
                MetaEmbed parentEmbed;
                String extend;
                MetaEmbed metaEmbed = (MetaEmbed)metaComponent2;
                this.metaForm.addEmbed(metaEmbed);
                if (newTemplateComponentArray == null) {
                    newTemplateComponentArray = new ArrayList<MetaComponent>();
                }
                if ((extend = this.metaForm.getExtend()) != null && !extend.isEmpty() && (parentEmbed = (metaForm = this.metaFactory.getMetaForm(extend)).embedByKey(metaEmbed.getKey())) != null) {
                    metaEmbed.merge(parentEmbed);
                }
                HashMap<String, Object> varValues = new HashMap<String, Object>();
                MetaEmbedVarCollection vars = metaEmbed.getVars();
                int size = vars.size();
                for (int i = 0; i < size; ++i) {
                    MetaVar var = (MetaVar)vars.get(i);
                    varValues.put(var.getKey(), var.getValue());
                }
                String templateFormKey = metaEmbed.getFormKey();
                MetaForm templateMetaForm = this.metaFactory.getMetaForm(templateFormKey);
                MetaComponent tmpMetaComponent = this.findComponent(templateMetaForm, rootKey = metaEmbed.getRootKey());
                if (tmpMetaComponent == null) {
                    throw new MetaException(71, SimpleStringFormat.format((String)StringTable.getString(null, "", "TemplateRootNotFound"), (Object[])new Object[]{templateFormKey, rootKey}));
                }
                MetaComponent newMetaComponent = (MetaComponent)tmpMetaComponent.depthClone();
                this.processTemplate(newMetaComponent, varValues);
                newMetaComponent.setWidth(metaComponent2.getWidth());
                newMetaComponent.setHeight(metaComponent2.getHeight());
                newMetaComponent.setArea(metaComponent2.getArea());
                newMetaComponent.setX(metaComponent2.getX());
                newMetaComponent.setY(metaComponent2.getY());
                newMetaComponent.setXSpan(metaComponent2.getXSpan());
                newMetaComponent.setYSpan(metaComponent2.getYSpan());
                if (newMetaComponent.isPanel()) {
                    if (this.comsMap == null) {
                        this.buildMap();
                    }
                    this.checkTemplate((MetaPanel)newMetaComponent);
                }
                newTemplateComponentArray.add(newMetaComponent);
                this.embedArray.add(newMetaComponent);
                if (metaEmbed.isIncludeDataTable().booleanValue() && (sourceDataObject = MetaUtil.getDataObject(this.metaFactory, templateMetaForm)) != null) {
                    MetaDataObject targetDataObject = MetaUtil.getDataObject(this.metaFactory, this.metaForm);
                    MetaDataObjectTemplateUtil util = new MetaDataObjectTemplateUtil(sourceDataObject, targetDataObject, "", varValues);
                    util.replace();
                }
                if ((metaMacroCollection = templateMetaForm.getMacroCollection()) != null) {
                    MetaMacroCollection newCollection = this.metaForm.getMacroCollection() == null ? new MetaMacroCollection() : this.metaForm.getMacroCollection();
                    for (Object metaMacro : metaMacroCollection) {
                        newCollection.add((MetaMacro)((MetaMacro)metaMacro).clone());
                    }
                    this.metaForm.setMacroCollection(newCollection);
                }
                if ((metaFormParaCollection = templateMetaForm.getFormParaCollection()) != null) {
                    Object metaMacro;
                    MetaFormParaCollection newCollection = this.metaForm.getFormParaCollection() == null ? new MetaFormParaCollection() : this.metaForm.getFormParaCollection();
                    metaMacro = metaFormParaCollection.iterator();
                    while (metaMacro.hasNext()) {
                        MetaFormPara metaFormPara = (MetaFormPara)metaMacro.next();
                        newCollection.add((MetaFormPara)metaFormPara.clone());
                    }
                    this.metaForm.setFormParaCollection(newCollection);
                }
                if ((metaQueryCollection = templateMetaForm.getQueryCollection()) != null) {
                    MetaQueryCollection newCollection = this.metaForm.getQueryCollection() == null ? new MetaQueryCollection() : this.metaForm.getQueryCollection();
                    for (Object metaQuery : metaQueryCollection) {
                        newCollection.add((MetaQuery)((MetaQuery)metaQuery).clone());
                    }
                    this.metaForm.setQueryCollection(newCollection);
                }
                if ((metaExtendCollection = templateMetaForm.getExtendCollection()) != null) {
                    Object metaQuery;
                    MetaExtendCollection newCollection = this.metaForm.getExtendCollection() == null ? new MetaExtendCollection() : this.metaForm.getExtendCollection();
                    metaQuery = metaExtendCollection.iterator();
                    while (metaQuery.hasNext()) {
                        MetaExtend metaExtend = (MetaExtend)metaQuery.next();
                        newCollection.add((MetaExtend)metaExtend.clone());
                    }
                    this.metaForm.setExtendCollection(newCollection);
                }
                if ((metaUICheckRuleCollection = templateMetaForm.getUICheckRuleCollection()) == null) continue;
                MetaUICheckRuleCollection newCollection = this.metaForm.getUICheckRuleCollection() == null ? new MetaUICheckRuleCollection() : this.metaForm.getUICheckRuleCollection();
                for (MetaUICheckRule metaUICheckRule : metaUICheckRuleCollection) {
                    newCollection.add((MetaUICheckRule)metaUICheckRule.clone());
                }
                this.metaForm.setUICheckRuleCollection(newCollection);
                continue;
            }
            if (metaComponent2.isPanel()) {
                this.processPanel((MetaPanel)metaComponent2);
                continue;
            }
            if (metaComponent2.getControlType() != 247 || (root = (metaSubDetail = (MetaSubDetail)metaComponent2).getRoot()) == null || !root.isPanel()) continue;
            this.processPanel((MetaPanel)root);
        }
        if (newTemplateComponentArray != null && !newTemplateComponentArray.isEmpty()) {
            LinkedList newComponentArray = new LinkedList();
            it = metaPanel.iteratorComponent();
            int index = 0;
            while (it.hasNext()) {
                metaComponent2 = it.next();
                if (metaComponent2.getControlType() == 253) {
                    newComponentArray.add(newTemplateComponentArray.get(index));
                    ++index;
                    continue;
                }
                newComponentArray.add(metaComponent2);
            }
            metaPanel.clear();
            for (MetaComponent metaComponent2 : newComponentArray) {
                metaPanel.addComponent(metaComponent2);
            }
        }
    }

    private MetaComponent findComponent(MetaForm targetMetaForm, String key) {
        MetaComponent metaComponent = null;
        MetaBody metaBody = targetMetaForm.getMetaBody();
        Iterator it = metaBody.iterator();
        MetaComponent tmpMetaComponent = null;
        while (it.hasNext()) {
            tmpMetaComponent = (MetaComponent)it.next();
            if (key.equalsIgnoreCase(tmpMetaComponent.getKey())) {
                metaComponent = tmpMetaComponent;
            } else {
                if (tmpMetaComponent.isPanel()) {
                    metaComponent = this.findComponent((MetaPanel)tmpMetaComponent, key);
                }
                if (tmpMetaComponent.getControlType() == 20000) {
                    MetaBlock metaBlock = (MetaBlock)tmpMetaComponent;
                    MetaComponent metaRoot = metaBlock.getRoot();
                    if (metaRoot.getKey().equalsIgnoreCase(key)) {
                        metaComponent = metaRoot;
                    } else if (metaRoot.isPanel()) {
                        metaComponent = this.findComponent((MetaPanel)metaRoot, key);
                    }
                }
            }
            if (metaComponent == null) continue;
            break;
        }
        return metaComponent;
    }

    private MetaComponent findComponent(MetaPanel metaPanel, String key) {
        MetaComponent metaComponent = null;
        Iterator<MetaComponent> it = metaPanel.iteratorComponent();
        MetaComponent tmpMetaComponent = null;
        while (it.hasNext()) {
            tmpMetaComponent = it.next();
            if (key.equalsIgnoreCase(tmpMetaComponent.getKey())) {
                metaComponent = tmpMetaComponent;
            } else if (tmpMetaComponent.isPanel()) {
                metaComponent = this.findComponent((MetaPanel)tmpMetaComponent, key);
            }
            if (metaComponent == null) continue;
            break;
        }
        return metaComponent;
    }

    private void processTemplate(MetaComponent metaComponent, HashMap<String, Object> vars) {
        if (metaComponent.isPanel()) {
            int size = metaComponent.getComponentCount();
            for (int i = 0; i < size; ++i) {
                MetaComponent metaChildComponent = metaComponent.getComponent(i);
                this.processTemplate(metaChildComponent, vars);
            }
        } else {
            switch (metaComponent.getControlType()) {
                case 216: {
                    this.processTemplateListView((MetaListView)metaComponent, vars);
                    break;
                }
                case 256: 
                case 257: 
                case 258: 
                case 259: 
                case 263: 
                case 305: {
                    this.processTemplateEditView((MetaEditView)metaComponent, vars);
                    break;
                }
                case 217: {
                    this.processTemplateGrid((MetaGrid)metaComponent, vars);
                    break;
                }
                default: {
                    this.processTemplateNormal(metaComponent, vars);
                }
            }
        }
    }

    private void processTemplateGrid(MetaGrid metaGrid, HashMap<String, Object> vars) {
        MetaGridRowCollection rowCollection = metaGrid.getRowCollection();
        Iterator itRow = rowCollection.iterator();
        MetaGridRow row = null;
        block4: while (itRow.hasNext()) {
            row = (MetaGridRow)itRow.next();
            switch (row.getRowType()) {
                case 0: {
                    int size = row.size();
                    for (int i = 0; i < size; ++i) {
                        String tableKey;
                        MetaGridCell cell = (MetaGridCell)row.get(i);
                        MetaDataBinding dataBinding = cell.getDataBinding();
                        if (dataBinding == null || (tableKey = dataBinding.getTableKey()) == null || tableKey.isEmpty()) continue;
                        dataBinding.setTableKey(SimpleStringFormat.format_v2((String)tableKey, vars));
                    }
                    continue block4;
                }
                case 2: {
                    String tableKey = row.getTableKey();
                    if (tableKey != null && !tableKey.isEmpty()) {
                        row.setTableKey(SimpleStringFormat.format_v2((String)tableKey, vars));
                    }
                    int size = row.size();
                    for (int i = 0; i < size; ++i) {
                        MetaGridCell cell = (MetaGridCell)row.get(i);
                        MetaDataBinding dataBinding = cell.getDataBinding();
                        if (dataBinding == null || (tableKey = dataBinding.getTableKey()) == null || tableKey.isEmpty()) continue;
                        dataBinding.setTableKey(SimpleStringFormat.format_v2((String)tableKey, vars));
                    }
                    break;
                }
            }
        }
    }

    private void processTemplateListView(MetaListView metaListView, HashMap<String, Object> vars) {
        String tableKey = metaListView.getTableKey();
        if (tableKey != null && !tableKey.isEmpty()) {
            metaListView.setTableKey(SimpleStringFormat.format_v2((String)tableKey, vars));
        }
    }

    private void processTemplateEditView(MetaEditView metaEditView, HashMap<String, Object> vars) {
        String tableKey = metaEditView.getTableKey();
        if (tableKey != null && !tableKey.isEmpty()) {
            metaEditView.setTableKey(SimpleStringFormat.format_v2((String)tableKey, vars));
        }
    }

    private void processTemplateNormal(MetaComponent metaComponent, HashMap<String, Object> vars) {
        String tableKey;
        MetaDataBinding dataBinding = metaComponent.getDataBinding();
        if (dataBinding != null && (tableKey = dataBinding.getTableKey()) != null && !tableKey.isEmpty()) {
            dataBinding.setTableKey(SimpleStringFormat.format_v2((String)tableKey, vars));
        }
    }
}

