/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.solution;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.IMetaResourceFilter;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.solution.MetaProject;
import java.io.File;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class MetaJarScanLoad
extends BaseMetaScanLoad {
    private String pluginsPath = null;
    private Set<String> jarNameSet = null;

    public MetaJarScanLoad(Set<String> jarNameSet, String pluginsPath, IMetaResolver resolver, MetaProject metaProject, Object context) {
        super(resolver, metaProject, "Enhance", context);
        this.pluginsPath = pluginsPath;
        this.fileFilter = ".jar";
        this.jarNameSet = jarNameSet;
        this.setFilter(new IMetaResourceFilter(){

            @Override
            public boolean isAccepted(String fileName) {
                return fileName.endsWith(".jar");
            }
        });
    }

    @Override
    public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
        try (InputStream is = this.resolver.read(filePath, -1);){
            if (is != null) {
                if (this.jarNameSet.contains(fileName)) {
                    throw new MetaException(115, SimpleStringFormat.format((String)StringTable.getString(null, "", "RepeatJarFileDefined"), (Object[])new Object[]{fileName}));
                }
                this.jarNameSet.add(fileName);
                File target = new File(this.pluginsPath, fileName);
                FileUtils.copyInputStreamToFile((InputStream)is, (File)target);
            }
        }
    }
}

