/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.solution;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.solution.MetaProject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public class MetaDataMigrationScanLoad
extends BaseMetaScanLoad {
    private int runType = 1;
    private MetaDataMigrationList migrationList = null;
    private Map<String, MetaDataMigrationProfile> map = null;

    public MetaDataMigrationScanLoad(MetaDataMigrationList migrationList, IMetaResolver resolver, MetaProject metaProject, Object context, int runType) {
        super(resolver, metaProject, "DataMigration", context);
        this.migrationList = migrationList;
        this.runType = runType;
        this.map = new ConcurrentHashMap<String, MetaDataMigrationProfile>();
    }

    protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaDataMigrationProfile profile) {
    }

    @Override
    protected void postLoad() throws Throwable {
        super.postLoad();
        this.merge();
    }

    @Override
    public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
        JSONObject profileInfo = this.resolver.readProfile(filePath, 0);
        if (profileInfo != null) {
            String tagName = profileInfo.optString("TagName");
            MetaDataMigrationProfile metaDataMigrationProfile = new MetaDataMigrationProfile();
            if ("DataMigration".equals(tagName)) {
                metaDataMigrationProfile.setKey(profileInfo.optString("Key"));
                metaDataMigrationProfile.setCaption(profileInfo.optString("Caption"));
                metaDataMigrationProfile.setExtend(profileInfo.optString("Extend"));
                metaDataMigrationProfile.setSrcDataObjectKey(profileInfo.optString("SrcDataObjectKey"));
                metaDataMigrationProfile.setTgtDataObjectKey(profileInfo.optString("TgtDataObjectKey"));
                metaDataMigrationProfile.setDescription(profileInfo.optString("Definition"));
                metaDataMigrationProfile.setStatusFieldKey(profileInfo.optString("StatusFieldKey"));
                metaDataMigrationProfile.setStatusValue(profileInfo.optString("StatusValue"));
                metaDataMigrationProfile.setCondition(profileInfo.optString("Condition"));
                metaDataMigrationProfile.setProject(this.metaProject);
                metaDataMigrationProfile.setResource(filePath);
                if (this.map.containsKey(metaDataMigrationProfile.getKey())) {
                    throw new MetaException(97, SimpleStringFormat.format((String)StringTable.getString(null, "", "RepeatDataMigrationDefined"), (Object[])new Object[]{this.metaProject.getKey(), metaDataMigrationProfile.getKey()}));
                }
                this.doFind(parent, parentPath, filePath, fileName, metaDataMigrationProfile);
                this.map.put(metaDataMigrationProfile.getKey(), metaDataMigrationProfile);
            }
        }
    }

    public int getRunType() {
        return this.runType;
    }

    private void merge() {
        if (this.map.isEmpty()) {
            return;
        }
        try {
            this.map.values().forEach(profile -> this.migrationList.add((MetaDataMigrationProfile)profile));
        }
        finally {
            this.map.clear();
        }
    }

    public MetaDataMigrationList getMetaDataMigrationList() {
        this.merge();
        return this.migrationList;
    }
}

