package com.bokesoft.yigo.meta.taskflow;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaTaskFlowList extends GenericKeyCollection<MetaTaskFlowProfile> implements IElementMerge<MetaTaskFlowList>{

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "TaskFlowList";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = null;
		if ( MetaTaskFlowProfile.TAG_NAME.equals(tagName) ) {
			MetaTaskFlowProfile metaFormProfile = new MetaTaskFlowProfile();
			metaFormProfile.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(metaFormProfile);
			child = metaFormProfile;
		}
		return child;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTaskFlowList();
	}

	@Override
	public MetaTaskFlowList toMerge(MetaTaskFlowList obj) {
		if (obj != null) {
			Iterator<MetaTaskFlowProfile> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaTaskFlowProfile flowProfile = (MetaTaskFlowProfile) iterator.next();
				if (containsKey(flowProfile.getKey())) {
					throw new MetaException(MetaException.REPEAT_KEY_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatTaskFlowDefined),
									flowProfile.getProject().getKey(), flowProfile.getKey()));
				}
				add(flowProfile);
			}
		}
		return this;
	}

}

