package com.bokesoft.yigo.meta.task;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.task.node.MetaTaskBegin;
import com.bokesoft.yigo.meta.task.node.MetaTaskDecision;
import com.bokesoft.yigo.meta.task.node.MetaTaskEnd;
import com.bokesoft.yigo.meta.task.node.MetaTaskException;
import com.bokesoft.yigo.meta.task.node.MetaTaskFork;
import com.bokesoft.yigo.meta.task.node.MetaTaskJoin;
import com.bokesoft.yigo.meta.task.node.MetaTaskNode;
import com.bokesoft.yigo.meta.task.node.MetaTaskWorker;

public class MetaTaskProcess  extends GenericKeyCollectionWithKey<MetaTaskNode>{

	public static final String TAG_NAME = "Process";
	
	private String key = "";
	private String caption = "";
	private Integer version = -1;
	
	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public Integer getVersion() {
		return version;
	}

	public void setVersion(Integer version) {
		this.version = version;
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = createNode(tagName);
		if (child != null) {
			child.preProcessMetaObject(env, doc, node, flag, runType);
			add((MetaTaskNode) child);
		}
		return child;
	}
	
	private MetaTaskNode createNode(String tagName) {
		MetaTaskNode node = null;
		if (MetaTaskBegin.TAG_NAME.equals(tagName)) {
			node = new MetaTaskBegin();
		}else if (MetaTaskWorker.TAG_NAME.equals(tagName)) {
			node = new MetaTaskWorker();
		}else if (MetaTaskException.TAG_NAME.equals(tagName)) {
			node = new MetaTaskException();
		}else if (MetaTaskFork.TAG_NAME.equals(tagName)) {
			node = new MetaTaskFork();
		}else if (MetaTaskDecision.TAG_NAME.equals(tagName)) {
			node = new MetaTaskDecision();
		}else if (MetaTaskJoin.TAG_NAME.equals(tagName)) {
			node = new MetaTaskJoin();
		}else if (MetaTaskEnd.TAG_NAME.equals(tagName)) {
			node = new MetaTaskEnd();
		}
		return node;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTaskProcess();
	}

}
