package com.bokesoft.yigo.meta.strings;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import org.json.JSONObject;

import com.bokesoft.yes.i18n.IStringMap;
import com.bokesoft.yes.i18n.XmlStringMapImpl;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.strings.MetaStringTableReader;
import com.bokesoft.yes.meta.persist.dom.strings.MetaStringTableSave;
import com.bokesoft.yigo.common.i18n.DefaultLocale;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;

public class MetaStringTable implements JSONSerializable, Serializable {
	private Map<String, IStringMap> localeMap = null;
	public MetaStringTable() {
		this.localeMap = new ConcurrentHashMap<String, IStringMap>();
	}
	
	public boolean hasLangLoaded(String lang) {
		return this.localeMap.containsKey(lang);
	}
	
	public void clear() {
		this.localeMap.clear();
	}
	
	public String getString(ILocale locale,
			String group, String key) {
		if ( locale == null ) {
			locale = DefaultLocale.getDefaultLocale();
		}
		String text = null;
		String lang = locale.getLocale();
		IStringMap map = this.localeMap.get(lang);
		if ( map == null ) {
			return null;
		}
		text = map.getString(group, key);

		return text;
	}
	
	public String getString(String lang, String group, String key) {
		String text = null;
		IStringMap map = this.localeMap.get(lang);
		if ( map == null ) {
			return null;
		}
		text = map.getString(group, key);

		return text;
	}

	public void load(String lang, IMetaFactory metaFactory, String project, String formKey) {
		if(!localeMap.containsKey(lang)){		
			String resource = DomMetaConstants.I18N_FOLD + File.separator +DomMetaConstants.FORM_FOLD + File.separator + formKey + "-" + lang + ".xml";
			IStringMap map = MetaStringTableReader.load(metaFactory, project, resource);
			this.localeMap.put(lang, map);	
		}
	}

	public void load(String lang, InputStream in) {
		IStringMap map = MetaStringTableReader.load(in);
		this.localeMap.put(lang, map);
	}

	public boolean containsLang(String lang) {
		return localeMap.containsKey(lang);
	}
	
	public Map<String, IStringMap> getLocaleMap() {
		return localeMap;
	}
	
	public void save(String resource){
		Set<Entry<String, IStringMap>> set = localeMap.entrySet();
		Iterator<Entry<String, IStringMap>> it = set.iterator();
		Entry<String, IStringMap> entry = null;
		while (it.hasNext()) {
			entry = it.next();
			IStringMap value = entry.getValue();
			try {
				XmlStringMapImpl impl = (XmlStringMapImpl)value;
				MetaStringTableSave.save(impl.save(), resource);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	@Override
	public JSONObject toJSON() throws Throwable {
		JSONObject o = new JSONObject();
		Iterator<String> keySet = localeMap.keySet().iterator();
		while ( keySet.hasNext() ) {
			String lang = keySet.next();
			IStringMap stringMap = localeMap.get(lang);
			o.put(lang, stringMap.toJSON());
		}
		return o;
	}

	@Override
	public void fromJSON(JSONObject o) throws Throwable {
		@SuppressWarnings("unchecked")
		Iterator<String> keySet = o.keys();
		while( keySet.hasNext() ) {
			String lang = keySet.next();
			JSONObject obj = o.optJSONObject(lang);
			XmlStringMapImpl impl = new XmlStringMapImpl();
			impl.fromJSON(obj);
			localeMap.put(lang, impl);
		}
	}
}
