package com.bokesoft.yigo.meta.solution;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaTrigger extends AbstractMetaObject{
	/** 触发器的名称*/
	private String name = "";
	/** 触发器的组别*/
	private String group = "";
	/** 延迟执行的时间,单位分钟*/
	private Integer delay = 0;// 分钟
	/** 重复次数,默认为-1,表示一直循环*/
	private Integer repeatCount = -1;
	/** 执行间隔,毫秒单位*/
	private String repeatInterval = "";
	
	public static final String TAG_NAME = "Trigger";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTrigger metaTrigger = new MetaTrigger();
		metaTrigger.setName(name);
		metaTrigger.setGroup(group);
		metaTrigger.setDelay(delay);
		metaTrigger.setRepeatCount(repeatCount);
		metaTrigger.setRepeatInterval(repeatInterval);
		return metaTrigger;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTrigger();
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getGroup() {
		return group;
	}

	public void setGroup(String group) {
		this.group = group;
	}

	public Integer getDelay() {
		return delay;
	}

	public void setDelay(Integer delay) {
		this.delay = delay;
	}

	public Integer getRepeatCount() {
		return repeatCount;
	}

	public void setRepeatCount(Integer repeatCount) {
		this.repeatCount = repeatCount;
	}

	public String getRepeatInterval() {
		return repeatInterval;
	}

	public void setRepeatInterval(String repeatInterval) {
		this.repeatInterval = repeatInterval;
	}

}
