package com.bokesoft.yigo.meta.setting;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.EncryptType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaLoginSetting extends AbstractMetaObject {
	/** 客户端登录界面,旧写法,现在用属性SessionPara代替*/
	private String normalAppLogin = "";
	/** 登陆处理程序,二开*/
	private String loginProcess = "";
	/** 登出处理程序,二开*/
	private String logoutProcess = "";
	/** 单点登陆处理类*/
	private String SSOProvider = "";
	/** 是否选择session参数登陆*/
	private Boolean sessionPara = false;
	/** 是否选择语种登陆*/
	private Boolean multiLang = false;
	/** 密码加密存储方式，默认值为RSA*/
	private Integer encryptType = EncryptType.RSA;
	/** 修改密码处理程序，二开*/
	private String changePwdProcess = "";
	/** 登陆超时后处理，二开*/
	private String overtimeProcess = "";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "Login";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}
	
	/**
	 * 设置普通客户端登录界面
	 * @param normalAppLogin 登录界面的实现类
	 */
	public void setNormalAppLogin(String normalAppLogin) {
		this.normalAppLogin = normalAppLogin;
	}
	
	/**
	 * 取得普通客户端登录界面
	 * @return 登录界面的实现类
	 */
	public String getNormalAppLogin() {
		return this.normalAppLogin;
	}
	
	/**
	 * 获取是否选择sessionPara登陆
	 * @return 是否选择sessionPara登陆
	 */
	public Boolean isSessionPara() {
		return sessionPara;
	}

	/**
	 * 设置是否选择sessionPara登陆
	 * @param sessionPara 是否选择sessionPara登陆
	 */
	public void setSessionPara(Boolean sessionPara) {
		this.sessionPara = sessionPara;
	}

	/**
	 * 获取单点登录处理类
	 * @return 处理类
	 */
	public String getSSOProvider() {
		return SSOProvider;
	}

	/**
	 * 设置单点登陆处理类
	 * @param SSOProvider 处理类
	 */
	public void setSSOProvider(String SSOProvider) {
		this.SSOProvider = SSOProvider;
	}

	/**
	 * 获取是否选择语言登陆
	 * @return 是否选择语言登陆 
	 */
	public Boolean isMultiLang() {
		return multiLang;
	}

	/**
	 * 设置是否选择语言登陆
	 * @param multiLang 是否选择语言登陆
	 */
	public void setMultiLang(Boolean multiLang) {
		this.multiLang = multiLang;
	}

	/**
	 * 获取登陆事件处理类
	 * @return 登陆事件处理类
	 */
	public String getLoginProcess() {
		return loginProcess;
	}

	/**
	 * 设置登陆事件处理类
	 * @param loginProcess 登陆事件处理类
	 */
	public void setLoginProcess(String loginProcess) {
		this.loginProcess = loginProcess;
	}
	
	/**
	 * 获取登出事件处理类
	 * @return 登出事件处理类
	 */
	public String getLogoutProcess() {
		return logoutProcess;
	}

	public Integer getEncryptType() {
		return encryptType;
	}

	public void setEncryptType(Integer encryptType) {
		this.encryptType = encryptType;
	}

	/**
	 * 获取修改密码处理类
	 * @return 修改密码处理类
	 * 
	 */
	public String getChangePwdProcess() {
		return changePwdProcess;
	}

	/**
	 * 设置修改密码处理类
	 * @param 修改密码处理类
	 */
	public void setChangePwdProcess(String changePwdProcess) {
		this.changePwdProcess = changePwdProcess;
	}

	/**
	 * 设置登出事件处理类
	 * @param logoutProcess 登出事件处理类
	 */
	public void setLogoutProcess(String logoutProcess) {
		this.logoutProcess = logoutProcess;
	}
	
	/**
	 * 获取超时后处理 
	 * @return 超时后处理
	 */
	public String getOvertimeProcess() {
		return overtimeProcess;
	}

	/**
	 * 设置超时后处理
	 * @param overtimeProce 超时处理 
	 */
	public void setOvertimeProcess(String overtimeProcess) {
		this.overtimeProcess = overtimeProcess;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaLoginSetting newObject = (MetaLoginSetting)newInstance();
		newObject.setNormalAppLogin(normalAppLogin);
		newObject.setLoginProcess(loginProcess);
		newObject.setLogoutProcess(logoutProcess);
		newObject.setSessionPara(sessionPara);
		newObject.setMultiLang(multiLang);
		newObject.setSSOProvider(SSOProvider);
		newObject.setEncryptType(encryptType);
		newObject.setChangePwdProcess(changePwdProcess);
		newObject.setOvertimeProcess(overtimeProcess);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaLoginSetting();
	}

}
