package com.bokesoft.yigo.meta.setting;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 工作流迁移表的列
 * 
 * @author 刘翔翔
 *
 */
public class MetaBPMMColumn extends KeyPairMetaObject {
	/** 列的标签名 */
	public static final String TAG_NAME = "Column";

	/** 列标志，表范围内唯一 */
	private String key = "";
	/** 列名称 */
	private String caption = "";
	/** 列的默认值 */
	private String defaultValue = "";
	/** 列的数据类型 */
	private Integer dataType = -1;
	/** 列存储数据所用的数据表的列名 */
	private String dbColumnName = "";
	/** 字符长度或二进制大小 */
	private Integer length = 0;
	/** 数值精度 */
	private Integer precision = 0;
	/** 小数位数 */
	private Integer scale = 0;

	@Override
	public String getKey() {
		return key;
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public Integer getDataType() {
		return dataType;
	}

	public void setDataType(Integer dataType) {
		this.dataType = dataType;
	}

	public String getDBColumnName() {
		return dbColumnName;
	}

	public void setDBColumnName(String dbColumnName) {
		this.dbColumnName = dbColumnName;
	}

	public Integer getLength() {
		return length;
	}

	public void setLength(Integer length) {
		this.length = length;
	}

	public Integer getPrecision() {
		return precision;
	}

	public void setPrecision(Integer precision) {
		this.precision = precision;
	}

	public Integer getScale() {
		return scale;
	}

	public void setScale(Integer scale) {
		this.scale = scale;
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBPMMColumn();
	}

	/**
	 * 取得绑定的数据表的列名
	 * 
	 * @return 返回绑定的数据表的列名，如果DBColumnName不为空，那么回返DBCo lumnName，否则返回Key
	 */
	public String getBindingDBColumnName() {
		return (dbColumnName != null && !dbColumnName.isEmpty()) ? dbColumnName : key;
	}

}
