package com.bokesoft.yigo.meta.report;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.intf.IMetaProject;

public class MetaReportProfile extends KeyPairMetaObject {
	/** 报表的标识 */
	private String key = "";
	/** 报表的名称 */
	private String caption = null;
	/** 报表的关联的表单表识 */
	private String formKey = "";
	/** 报表的分组标识 */
	private String group = "";
	/** 是否表单中的默认模板 */
	private boolean isDefault = true;
	/** 报表配置 */
	private MetaReport report = null;
	/** 工程引用 */
	private IMetaProject project = null;
	/** 资源 */
	private String resource = null;
	
	@Override
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置报表的标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 设置报表的名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得报表的名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置报表的关联表单标识
	 * @param formKey 表单标识
	 */
	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
	
	/**
	 * 取得报表的关联表单标识
	 * @return 表单标识
	 */
	public String getFormKey() {
		return this.formKey;
	}
	
	/**
	 * 设置报表分组
	 * @param group 报表分组
	 */
	public void setGroup(String group) {
		this.group = group;
	}
	
	/**
	 * 取得报表分组
	 * @return 报表分组
	 */
	public String getGroup() {
		return this.group;
	}
	
	/**
	 * 设置是否表单中的默认模板
	 * @param isDefault 默认标志
	 */
	public void setDefault(boolean isDefault) {
		this.isDefault = isDefault;
	}
	
	/**
	 * 取得是否表单中的默认模板
	 * @return 默认标志
	 */
	public boolean isDefault() {
		return this.isDefault;
	}
	
	/**
	 * 设置报表配置
	 * @param report 报表配置
	 * @see MetaReport
	 */
	public void setReport(MetaReport report) {
		this.report = report;
	}
	
	/**
	 * 取得报表配置
	 * @return 报表配置
	 * @see MetaReport
	 */
	public MetaReport getReport() {
		return this.report;
	}
	
	/**
	 * 设置工程引用
	 * @param project 工程引用
	 */
	public void setProject(IMetaProject project) {
		this.project = project;
	}
	
	/**
	 * 取得工程引用
	 * @return 工程引用
	 */
	public IMetaProject getProject() {
		return this.project;
	}
	
	/**
	 * 设置资源
	 * @param resource 资源
	 */
	public void setResource(String resource) {
		this.resource = resource;
	}
	
	/**
	 * 取得资源
	 * @return 资源
	 */
	public String getResource() {
		return this.resource;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}

}
