package com.bokesoft.yigo.meta.report;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaReportListItem extends AbstractMetaObject{
	public MetaReportListItem() {
		super();
	}
	
	/** 值 */
	private String value = null;
	/** 文本 */
	private String text = null;
	
	/**
	 * 设置值
	 * @param value 值
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
	/**
	 * 取得值
	 * @return 值
	 */
	public String getValue() {
		return value;
	}

	/**
	 * 设置文本
	 * @param text 文本
	 */
	public void setText(String text) {
		this.text = text;
	}

	/**
	 * 取得文本
	 * @return 文本
	 */
	public String getText() {
		return text;
	}
	
	public static final String TAG_NAME = "ListItem";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaReportListItem newObject = (MetaReportListItem)newInstance();
		newObject.setValue(this.value);
		newObject.setText(this.text);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaReportListItem();
	}
}
