package com.bokesoft.yigo.meta.report;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaReportFormat extends AbstractMetaObject {
	/** 数据类型 */
	private Integer dataType = ReportFormatDataType.Text;
	/** 数据转换器 */
	private String transformer = "";
	/** 格式字符串 */
	private String formatString = "";
	/** 字典标识 */
	private String itemKey = "";
	/** 字段列表 */
	private String fieldKeys = "";
	
	private List<MetaReportListItem> listItems = null;
	
	public MetaReportFormat() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if(listItems != null) {
			list.add(listItems);
		}
	}

	public static final String TAG_NAME = "Format";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置数据类型
	 * @param dataType 数据类型
	 */
	public void setDataType(Integer dataType) {
		this.dataType = dataType;
	}
	
	/**
	 * 取得数据类型
	 * @return 数据类型
	 */
	public Integer getDataType() {
		return this.dataType;
	}
	
	/**
	 * 设置数据转换器
	 * @param transformer 数据转换器
	 */
	public void setTransformer(String transformer) {
		this.transformer = transformer;
	}
	
	/**
	 * 取得数据转换器
	 * @return 数据转换器
	 */
	public String getTransformer() {
		return this.transformer;
	}
	
	/**
	 * 设置格式字符串
	 * @param formatString 格式字符串
	 */
	public void setFormatString(String formatString) {
		this.formatString = formatString;
	}
	
	/**
	 * 取得格式字符串
	 * @return 格式字符串
	 */
	public String getFormatString() {
		return this.formatString;
	}
	
	/**
	 * 设置字典标识
	 * @param itemKey 字典标识
	 */
	public void setItemKey(String itemKey) {
		this.itemKey = itemKey;
	}
	
	/**
	 * 取得字典标识
	 * @return 字典标识
	 */
	public String getItemKey() {
		return this.itemKey;
	}
	
	/**
	 * 设置字段列表
	 * @param fieldKeys 字段列表
	 */
	public void setFieldKeys(String fieldKeys) {
		this.fieldKeys = fieldKeys;
	}
	
	/**
	 * 取得字段列表
	 * @return 字段列表
	 */
	public String getFieldKeys() {
		return this.fieldKeys;
	}

	public void setListItems(List<MetaReportListItem> listItems) {
		this.listItems = listItems;
	}
	
	public List<MetaReportListItem> getListItems() {
		return this.listItems;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject metaObject = null;
		if ( MetaReportListItem.TAG_NAME.equals(tagName) ) {
			MetaReportListItem listItem = new MetaReportListItem();
			listItem.preProcessMetaObject(env, doc, node, flag, runType);
			if(this.listItems == null)
				listItems = new ArrayList<MetaReportListItem>();
			listItems.add(listItem);
			metaObject = listItem;
		}
		return metaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaReportFormat newObject = (MetaReportFormat)newInstance();
		newObject.setDataType(this.dataType);
		newObject.setTransformer(this.transformer);
		newObject.setFormatString(this.formatString);
		newObject.setItemKey(this.itemKey);
		newObject.setFieldKeys(this.fieldKeys);
		if (this.listItems != null) {
			List<MetaReportListItem> newListItems = new ArrayList<MetaReportListItem>();
			for (MetaReportListItem item : this.listItems)
				newListItems.add((MetaReportListItem) item.clone());
			newObject.setListItems(newListItems);
		}
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaReportFormat();
	}
	
}
