package com.bokesoft.yigo.meta.report;

import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.PlotOrientation;
import com.bokesoft.yigo.common.def.PrintOrderType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.report.embed.MetaReportEmbed;

public class MetaReport extends AbstractMetaObject {
	public static final String TAG_NAME = "Report";
	/** 报表的标识，在整个报表系统中需要唯一，在生成报表时，需要根据该标识获取报表模板 */
	private String key = "";
	/** 报表的名称 */
	private String caption = "";
	/** 表单的标识 */
	private String formKey = "";
	/** 报表组 */
	private String group = "";
	/** 是否表单中默认模板 */
	private Boolean isDefault = true;
	/** 是否虚拟页标志 */
	private Boolean isVirtualPage = false;
	/** 页面标识 */
	private String pageID = "A4";
	/** 页面宽度 */
	private Integer pageWidth = 0;
	/** 页面高度 */
	private Integer pageHeight = 0;
	/** 纸张标识 */
	private String paperID = "A4";
	/** 纸张宽度 */
	private Integer paperWidth = 0;
	/** 纸张高度 */
	private Integer paperHeight = 0;
	/** 左边距 */
	private Integer leftMargin = 0;
	/** 顶边距 */
	private Integer topMargin = 0;
	/** 右边距 */
	private Integer rightMargin = 0;
	/** 底边距 */
	private Integer bottomMargin = 0;
	/** 页面方位 */
	private Integer pageOrientation = PlotOrientation.Portrait;
	/** 纸张方位 */
	private Integer paperOrientation = PlotOrientation.Portrait;
	/** 打印顺序类型 */
	private Integer printOrderType = PrintOrderType.PrimaryMixed;	
	/** 报表的数据源定义 */
	private MetaReportDataSource reportDataSource = null;
	/** 报表的网格定义 */
	private MetaReportGrid grid = null;
	/** 嵌入对象 */
	private MetaReportEmbed embed = null;
	/** 水印 */
	private MetaReportWaterprint waterprint = null;
	
	private transient IMetaProject project = null;

	public MetaReport() {
		super();
	}

	/**
	 * 设置报表标识
	 * @param key 报表标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得报表标识
	 * @return 报表标识
	 */
	public String getKey() {
		return key;
	}

	/**
	 * 设置报表名称
	 * @param caption 报表名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得报表名称
	 * @return 报表名称
	 */
	public String getCaption() {
		return caption;
	}
	
	/**
	 * 设置表单标识
	 * @param formKey 表单标识
	 */
	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
	
	/**
	 * 取得表单标识
	 * @return 表单标识
	 */
	public String getFormKey() {
		return this.formKey;
	}
	
	/**
	 * 设置报表组
	 * @param group 报表组
	 */
	public void setGroup(String group) {
		this.group = group;
	}
	
	/**
	 * 取得报表组
	 * @return 报表组
	 */
	public String getGroup() {
		return this.group;
	}
	
	/**
	 * 设置是否表单中的默认模板
	 * @param isDefault 默认标志
	 */
	public void setDefault(Boolean isDefault) {
		this.isDefault = isDefault;
	}
	
	/**
	 * 判断是否表单中的默认模板
	 * @return 默认标志
	 */
	public Boolean isDefault() {
		return this.isDefault;
	}
	
	/**
	 * 设置虚拟页标志
	 * @param virtualPage 虚拟页标志
	 */
	public void setVirtualPage(Boolean virtualPage) {
		this.isVirtualPage = virtualPage;
	}
	
	/**
	 * 取得虚拟页标志
	 * @return 虚拟页标志
	 */
	public Boolean isVirtualPage() {
		return this.isVirtualPage;
	}
	
	/**
	 * 设置页面标识
	 * @param pageID 页面标识
	 */
	public void setPageID(String pageID) {
		this.pageID = pageID;
	}
	
	/**
	 * 取得页面标识
	 * @return 页面标识
	 */
	public String getPageID() {
		return this.pageID;
	}
	
	/**
	 * 设置页面宽度
	 * @param pageWidth 页面宽度
	 */
	public void setPageWidth(Integer pageWidth) {
		this.pageWidth = pageWidth;
	}
	
	/**
	 * 取得页面宽度
	 * @return 页面宽度
	 */
	public Integer getPageWidth() {
		return this.pageWidth;
	}
	
	/**
	 * 设置页面高度
	 * @param pageHeight 页面高度
	 */
	public void setPageHeight(Integer pageHeight) {
		this.pageHeight = pageHeight;
	}
	
	/**
	 * 取得页面高度
	 * @return 页面高度
	 */
	public Integer getPageHeight() {
		return this.pageHeight;
	}
	
	/**
	 * 设置纸张标识
	 * @param paperID 纸张标识
	 */
	public void setPaperID(String paperID) {
		this.paperID = paperID;
	}
	
	/**
	 * 取得纸张标识
	 * @return 纸张标识
	 */
	public String getPaperID() {
		return this.paperID;
	}
	
	/**
	 * 设置纸张宽度
	 * @param paperWidth 纸张宽度
	 */
	public void setPaperWidth(Integer paperWidth) {
		this.paperWidth = paperWidth;
	}
	
	/**
	 * 取得纸张宽度
	 * @return 纸张宽度
	 */
	public Integer getPaperWidth() {
		return this.paperWidth;
	}
	
	/**
	 * 设置纸张高度
	 * @param paperHeight 纸张高度
	 */
	public void setPaperHeight(Integer paperHeight) {
		this.paperHeight = paperHeight;
	}
	
	/**
	 * 取得纸张高度
	 * @return 纸张高度
	 */
	public Integer getPaperHeight() {
		return this.paperHeight;
	}
	
	/**
	 * 设置左边距
	 * @param leftMargin 左边距
	 */
	public void setLeftMargin(Integer leftMargin) {
		this.leftMargin = leftMargin;
	}
	
	/**
	 * 取得左边距
	 * @return 左边距
	 */
	public Integer getLeftMargin() {
		return this.leftMargin;
	}
	
	/**
	 * 设置顶边距
	 * @param topMargin 顶边距
	 */
	public void setTopMargin(Integer topMargin) {
		this.topMargin = topMargin;
	}
	
	/**
	 * 取得顶边距
	 * @return 顶边距
	 */
	public Integer getTopMargin() {
		return this.topMargin;
	}
	
	/**
	 * 设置右边距
	 * @param rightMargin 右边距
	 */
	public void setRightMargin(Integer rightMargin) {
		this.rightMargin = rightMargin;
	}
	
	/**
	 * 取得右边距
	 * @return 右边距
	 */
	public Integer getRightMargin() {
		return this.rightMargin;
	}
	
	/**
	 * 设置底边距
	 * @param bottomMargin 底边距
	 */
	public void setBottomMargin(Integer bottomMargin) {
		this.bottomMargin = bottomMargin;
	}
	
	/**
	 * 取得底边距
	 * @return 底边距
	 */
	public Integer getBottomMargin() {
		return this.bottomMargin;
	}
	
	/**
	 * 设置页面方位
	 * @param pageOrientation 页面方位
	 */
	public void setPageOrientation(Integer pageOrientation) {
		this.pageOrientation = pageOrientation;
	}
	
	/**
	 * 取得页面方位
	 * @return 页面方位
	 */
	public Integer getPageOrientation() {
		return this.pageOrientation;
	}
	
	/**
	 * 设置纸张方位
	 * @param paperOrientation 纸张方位
	 */
	public void setPaperOrientation(Integer paperOrientation) {
		this.paperOrientation = paperOrientation;
	}
	
	/**
	 * 取得纸张方位
	 * @return 纸张方位
	 */
	public Integer getPaperOrientation() {
		return this.paperOrientation;
	}

	/**
	 * 设置报表数据源定义
	 * @param reportDataSource 报表数据源定义
	 */
	public void setDataSource(MetaReportDataSource reportDataSource) {
		this.reportDataSource = reportDataSource;
	}

	/**
	 * 取得报表数据源定义
	 * @return 报表数据源定义
	 */
	public MetaReportDataSource getDataSource() {
		return reportDataSource;
	}

	/**
	 * 设置报表体定义
	 * @param grid 报表体定义
	 */
	public void setGrid(MetaReportGrid grid) {
		this.grid = grid;
	}

	/**
	 * 取得报表体定义
	 * @return 报表体定义
	 */
	public MetaReportGrid getGrid() {
		return grid;
	}
	
	/**
	 * 设置嵌入对象
	 * @param embed 嵌入对象
	 */
	public void setEmbed(MetaReportEmbed embed) {
		this.embed = embed;
	}
	
	/**
	 * 取得嵌入对象
	 * @return 嵌入对象
	 */
	public MetaReportEmbed getEmbed() {
		return this.embed;
	}
	
	/**
	 * 设置水印
	 * @param waterprint 水印
	 */
	public void setWaterprint(MetaReportWaterprint waterprint) {
		this.waterprint = waterprint;
	}
	
	/**
	 * 取得水印
	 * @return 水印
	 */
	public MetaReportWaterprint getWaterprint() {
		return this.waterprint;
	}
	
	/**
	 * 设置打印属性
	 * @param printOrderType
	 */
	public void setPrintOrderType(Integer printOrderType) {
		this.printOrderType = printOrderType;
	}
	
	/**
	 * 获取打印顺序
	 * @return
	 */
	public Integer getPrintOrderType() {
		return this.printOrderType;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		if (MetaReportDataSource.TAG_NAME.equals(tagName)) {
			reportDataSource = new MetaReportDataSource();
			return reportDataSource;
		} else if (MetaReportGrid.TAG_NAME.equals(tagName)) {
			grid = new MetaReportGrid();
			return grid;
		} else if ( MetaReportEmbed.TAG_NAME.equals(tagName)) {
			embed = new MetaReportEmbed();
			return embed;
		} else if ( MetaReportWaterprint.TAG_NAME.equals(tagName) ) {
			waterprint = new MetaReportWaterprint();
			return waterprint;
		}
		else {
			throw new MetaException(
					MetaException.UNSUPPORTED_TAG_NAME,
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.UnsupportedTagName), tagName));
			}
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		this.addAll2(list, this.reportDataSource, this.grid, this.embed, this.waterprint);
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaReport newReport = new MetaReport();
		newReport.setKey(key);
		newReport.setCaption(caption);
		newReport.setFormKey(formKey);
		newReport.setGroup(group);
		newReport.setDefault(isDefault);
		newReport.setVirtualPage(isVirtualPage);
		newReport.setPageID(pageID);
		newReport.setPageWidth(pageWidth);
		newReport.setPageHeight(pageHeight);
		newReport.setPaperID(paperID);
		newReport.setPaperWidth(paperWidth);
		newReport.setPaperHeight(paperHeight);
		newReport.setLeftMargin(leftMargin);
		newReport.setTopMargin(topMargin);
		newReport.setRightMargin(rightMargin);
		newReport.setBottomMargin(bottomMargin);
		newReport.setPageOrientation(pageOrientation);
		newReport.setPaperOrientation(paperOrientation);
		newReport.setPrintOrderType(printOrderType);
		newReport.setDataSource(reportDataSource == null ? null : (MetaReportDataSource) reportDataSource.clone()); 
		newReport.setGrid(grid == null ? null : (MetaReportGrid) grid.clone());
		newReport.setEmbed(embed == null ? null : (MetaReportEmbed) embed.clone());
		newReport.setWaterprint(waterprint == null ? null : (MetaReportWaterprint) waterprint.clone());
		return newReport;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaReport();
	}
	
	/**
	 * 设置工程引用
	 *
	 * @param project
	 *            工程引用的接口
	 */
	public void setProject(IMetaProject project) {
		this.project = project;
	}

	/**
	 * 获取工程引用
	 *
	 * @return 工程引用接口
	 */
	public IMetaProject getProject() {
		return project;
	}
	
	public String getProjectKey() {
		if(project == null) {
			return "";
		}
		return project.getKey();
	}
}
