package com.bokesoft.yigo.meta.permission.custom;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map.Entry;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaCustomPermission extends GenericKeyCollection<MetaGroup> {
	public static final String TAG_NAME ="CustomPermission";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {		
		Iterator<Entry<String, MetaGroup>> itEntry = elementMap.entrySet().iterator();
		Entry<String, MetaGroup> entry = null;
		while (itEntry.hasNext()) {
			entry = itEntry.next();
			MetaGroup group = entry.getValue();
			list.add(group);
		}
		//System.out.println("--- MetaCustomPermission.getChildMetaObjects().list:"+list.toString());
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (MetaGroup.TAG_NAME.equals(tagName)) {
			MetaGroup item = new MetaGroup();
			item.preProcessMetaObject(env, doc, node, flag, runType);
			add(item);
			child = item;
		}
		return child;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCustomPermission();
	}

}
