package com.bokesoft.yigo.meta.mobiledef.encrypt;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MobileDef中的关于服务请求进行数据加密的相关设置，目前只有加密的秘钥设置。
 * 
 * 目前参考格式如下：
 * <pre>
 * {@code 
 * <Encrypt Impl="com.bokesoft.yeslibrary.proxy.encrypt.AESEncrypt">
 * 	<SecretKey>1234567812345678</SecretKey>
 * </Encrypt>
 * }
 * </pre>
 * @author chenzs
 *
 */
public class MetaEncryptSetting extends GenericKeyCollection<MetaEncryptPara> {
	
	/** 配置对象标签名称*/
	public static final String TAG_NAME = "Encrypt";
	
	/** 加密算法的实现类的完整引用路径*/
	private String impl = null;
	
	/**
	 * 设置加密算法的实现类的完整引用路径
	 * @param impl 加密算法的实现类的完整引用路径
	 */
	public void setImpl(String impl) {
		this.impl = impl;
	}
	
	/**
	 * 获取加密算法的实现类的完整引用路径
	 * @return 加密算法的实现类的完整引用路径
	 */
	public String getImpl() {
		return impl;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		MetaEncryptPara metaObject = new MetaEncryptPara();
		metaObject.setKey(tagName);
		this.add(metaObject);
		return metaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaEncryptSetting();
	}
	
	@Override
	public MetaEncryptSetting clone() {
		MetaEncryptSetting newObj = (MetaEncryptSetting)super.clone();
		newObj.setImpl(impl);
		return newObj;
	}
}
