package com.bokesoft.yigo.meta.form.component.view.layout;

import java.util.LinkedList;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormActionMap;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormLoadContext;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaAction;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaFont;
import com.bokesoft.yigo.meta.form.component.MetaFormat;

/**
 * MetaLayoutItem定义布局项的基类
 * @author 王元和
 *
 */
public abstract class MetaLayoutItem extends KeyPairMetaObject {	
	protected String key = "";
	
	/** 临时变量，后期处理完删除*/
	private  MetaFormat format = null;
	/** 临时变量，后期处理完删除*/
	private  Document document = null;
	/** 临时变量，后期处理完删除*/
	private  Element element = null;
	/** 临时变量，后期处理完删除*/
	private  Integer runType = null;
	
	
	public MetaLayoutItem() {
		super();
	}
	
	public void setKey(String key) {
		this.key = key;
	}
	
	@Override
	public String getKey() {
		return key;
	}

	public void setLoadTemp(Document document,Element element,int runType){
		this.document = document;
		this.element = element;
		this.runType = runType;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if(format != null)
			list.add(format);
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		if(tagName.equals(MetaFormat.TAG_NAME)){
			format = new MetaFormat();
			return format;
		}
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaLayoutItem newObject = (MetaLayoutItem)newInstance();
		newObject.setKey(key);
		return newObject;
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback)
			throws MetaException {
		super.doPostProcess(flag, callback);
		MetaComponent metaComp = MetaFormLoadContext.getComponentByKey(key);
		if(metaComp != null) {
			if(format != null ) {
				loadFormat(format, metaComp);
			}
			if(document != null && element != null && runType != null) {
				IMetaAction action = MetaFormActionMap.getInstance().getAction(
						metaComp.getTagName());
				if (action instanceof BaseDomAction) {
					((BaseDomAction) action).load(document, element, metaComp, runType);
				}
			}
		}
		format = null;
		document = null;
		element = null;
		runType = null;
	}

	/**
	 * 将Format子节点中有的属性设置到对应的组件中
	 *
	 * @param format   用于设置的Format子节点
	 * @param metaComp 被设置的组件配置对象
	 */
	public static void loadFormat(MetaFormat format, MetaComponent metaComp) {
		MetaFormat compFormat = metaComp.ensureFormat();

		int hAlign = format.getHAlign();
		if (hAlign >= 0) {
			compFormat.setHAlign(hAlign);
		}
		int vAlign = format.getVAlign();
		if (vAlign >= 0) {
			compFormat.setVAlign(vAlign);
		}
		String foreColor = format.getForeColor();
		if (foreColor != null && !foreColor.isEmpty()) {
			compFormat.setForeColor(foreColor);
		}
		String backColor = format.getBackColor();
		if (backColor != null && !backColor.isEmpty()) {
			compFormat.setBackColor(backColor);
		}
		String highlightBackColor = format.getHighlightBackColor();
		if (highlightBackColor != null && !highlightBackColor.isEmpty()) {
			compFormat.setHighlightBackColor(highlightBackColor);
		}

		MetaFont font = format.getFont();
		if (font != null) {
			MetaFont compFont = compFormat.getFont();
			if (compFont == null) {
				compFont = new MetaFont();
				compFormat.setFont(compFont);
			}

			String name = font.getName();
			if (name != null && !name.isEmpty()) {
				compFont.setName(name);
			}
			int size = font.getSize();
			if (size >= 0) {
				compFont.setSize(size);
			}
			Boolean bold = font.getBold();
			if (bold != null) {
				compFont.setBold(bold);
			}
			Boolean italic = font.getItalic();
			if (italic != null) {
				compFont.setItalic(italic);
			}
		}
	}
}
