package com.bokesoft.yigo.meta.form.component.view.layout;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;

public class MetaCustomLayout extends MetaComponentLayout<MetaLayoutSpan> {
	private MetaRowDefCollection rowDefCollection = null;
	private MetaColumnDefCollection columnDefCollection = null;
	@Override
	public int getLayoutType() {
		return LayoutType.LAYOUT_CUSTOM;
	}

	public static final String TAG_NAME = "CustomLayout";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new Object[] {
				rowDefCollection, columnDefCollection
		});
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaCustomLayout newObject = (MetaCustomLayout)super.clone();
		newObject.setRowDefCollection(rowDefCollection == null ? null : (MetaRowDefCollection)rowDefCollection.clone());
		newObject.setColumnDefCollection(columnDefCollection == null ? null : (MetaColumnDefCollection)columnDefCollection.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCustomLayout();
	}
	
	public void setRowDefCollection(MetaRowDefCollection rowDefCollection) {
		this.rowDefCollection = rowDefCollection;
	}
	
	public MetaRowDefCollection getRowDefCollection() {
		return this.rowDefCollection;
	}
	
	public void setColumnDefCollection(MetaColumnDefCollection columnDefCollection) {
		this.columnDefCollection = columnDefCollection;
	}
	
	public MetaColumnDefCollection getColumnDefCollection() {
		return this.columnDefCollection;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaLayoutSpan.TAG_NAME.equals(tagName) ) {
			MetaLayoutSpan item = new MetaLayoutSpan();
			item.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(item);
			resultMetaObject = item;
		} else if ( MetaRowDefCollection.TAG_NAME.equals(tagName) ) {
			rowDefCollection = new MetaRowDefCollection();
			resultMetaObject = rowDefCollection;
		} else if ( MetaColumnDefCollection.TAG_NAME.equals(tagName) ) {
			columnDefCollection = new MetaColumnDefCollection();
			resultMetaObject = columnDefCollection;
		}
		return resultMetaObject;
	}
}
