package com.bokesoft.yigo.meta.form.component.panel.collapsepanel;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.CollapseType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;

/**
 * 折叠布局面板对象
 * 
 * @author MY
 */
public class MetaCollapsePanel extends MetaPanel {

	/** 配置文件中对应节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_COLLAPSEPANEL;

	/** 模式，默认为Multiple-可以全部展开 */
	private Integer collapseType = CollapseType.MULTIPLE;
	/** 折叠面板布局项 */
	private MetaCollapseCollection items;

	public MetaCollapseCollection getItems() {
		return items;
	}

	public void setItems(MetaCollapseCollection items) {
		this.items = items;
	}

	/**
	 * 构造方法，初始化items
	 */
	public MetaCollapsePanel() {
		super();
		items = new MetaCollapseCollection();
	}

	/**
	 * 设置折叠面板模式
	 * 
	 * @param CollapseType
	 *            显示模式，参考{@link CollapseType}
	 */
	public void setCollapseType(Integer collapseType) {
		this.collapseType = collapseType;
	}

	/**
	 * 获取折叠面板模式
	 * 
	 * @return 显示模式，参考{@link CollapseType}
	 */
	public Integer getCollapseType() {
		return collapseType;
	}

	@Override
	public int getControlType() {
		return ControlType.COLLAPSEPANEL;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCollapsePanel();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCollapsePanel newObject = (MetaCollapsePanel) super.clone();
		newObject.setCollapseType(collapseType);
		newObject.setItems(items == null ? null : (MetaCollapseCollection)items.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaCollapseItem.TAG_NAME.equals(tagName)) {
			resultMetaObject = items.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		if (resultMetaObject == null) {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}

	@Override
	public MetaComponentLayout<?> newLayout() {
		return null;
	}
	

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new AbstractMetaObject[] {items});
	}

}
