package com.bokesoft.yigo.meta.form.component.panel;

import java.util.Iterator;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlowLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutFlowIndex;

public class MetaFlowLayoutPanel extends MetaPanel {
	public MetaFlowLayoutPanel() {
		super();
	}
	
	public static final String TAG_NAME = ControlType.STR_FLOWLAYOUTPANEL;
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.FLOWLAYOUTPANEL;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFlowLayoutPanel();
	}

	/**
	 * 从流布局面板中生成流布局
	 * @return 流布局
	 */
	@Override
	public MetaFlowLayout newLayout() {
		MetaFlowLayout layout = new MetaFlowLayout();
		layout.setKey(key);
		Iterator<MetaComponent> it = this.componentArray.iterator();
		MetaComponent metaComponent = null;
		while ( it.hasNext() ) {
			metaComponent = it.next();
			MetaLayoutFlowIndex item = new MetaLayoutFlowIndex();
			item.setKey(metaComponent.getKey());
			item.setHeight(metaComponent.getHeight());
			layout.add(item);
		}
		return layout;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
}
