package com.bokesoft.yigo.meta.form.component.panel;

import java.util.Iterator;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlexFlowLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutFlowIndex;

public class MetaFlexFlowLayoutPanel extends MetaPanel {
	public MetaFlexFlowLayoutPanel() {
		super();
	}
	
	public static final String TAG_NAME = ControlType.STR_FLEXFLOWLAYOUTPANEL;
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.FLEXFLOWLAYOUTPANEL;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFlexFlowLayoutPanel();
	}
	
	/**
	 * 从弹性流布局面板中生成弹性流布局
	 * @return 弹性流布局
	 */
	@Override
	public MetaFlexFlowLayout newLayout() {
		MetaFlexFlowLayout layout = new MetaFlexFlowLayout();
		layout.setKey(key);
		Iterator<MetaComponent> it = this.componentArray.iterator();
		MetaComponent metaComponent = null;
		while ( it.hasNext() ) {
			metaComponent = it.next();
			MetaLayoutFlowIndex item = new MetaLayoutFlowIndex();
			item.setKey(metaComponent.getKey());
			item.setHeight(metaComponent.getHeight());
			layout.add(item);
		}
		return layout;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
}
