package com.bokesoft.yigo.meta.form.component.panel;

import java.util.Iterator;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaColumnLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSpan;

/**
 * 列式布局面板对象，从基础类派生而来，属于布局类控件，包含布局信息
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaColumnLayoutPanel extends MetaPanel {

	/** 配置文件中对应节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_COLUMNLAYOUTPANEL;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.COLUMNLAYOUTPANEL;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaColumnLayoutPanel();
	}
	
	/**
	 * 从列式布局面板中生成列式布局
	 * @return 列式布局
	 */
	@Override
	public MetaColumnLayout newLayout() {
		MetaColumnLayout layout = new MetaColumnLayout();
		layout.setKey(key);
		Iterator<MetaComponent> it = this.componentArray.iterator();
		MetaComponent metaComponent = null;
		while ( it.hasNext() ) {
			metaComponent = it.next();
			MetaLayoutSpan item = new MetaLayoutSpan();
			item.setKey(metaComponent.getKey());
			item.setX(metaComponent.getX());
			item.setY(metaComponent.getY());
			item.setXSpan(metaComponent.getXSpan());
			item.setYSpan(metaComponent.getY());
			item.setHeight(metaComponent.getHeight());
			item.setControlType(metaComponent.getControlType());
			layout.add(item);
		}
		return layout;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
}
