package com.bokesoft.yigo.meta.form.component.grid.dynamic;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaDynamicProperties;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaCondition;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaBarCoderProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckListBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCustomProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDatePickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaHyperLinkProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaImageProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaLabelProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaMonthPickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaMultiStateButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNoticeBarProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPriceLabelProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaRelativeTimeProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextAreaProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTimePickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaToggleButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaUTCDatePickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaVideoPlayerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaWizardListProperties;

/**
 * MetaCellTypeDef用于定义表格中的单元格类型的额外属性
 * @author wangyh
 *
 */
public class MetaCellTypeDef extends KeyPairMetaObject {
	/** 标识 */
	private String key = "";
	/** 名称*/
	private String caption = "";
	/** 类型 */
	private Integer type = -1;
	/** 默认值 */
	private String defaultValue = "";
	
	public static final String TAG_NAME = "CellTypeDef";
	/** 其它属性定义 */
	private AbstractMetaObject properties = null;
	
	/** 组件的查询关联 */
	private MetaCondition condition = null;

	@Override
	public String getKey() {
		return key;
	}
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 获取标题
	 * @return 标题
	 */
	public String getCaption() {
		return caption;
	}

	/**
	 * 设置标题
	 * @param caption 标题
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * 取得类型
	 * @return 类型
	 */
	public Integer getType() {
		return type;
	}

	/**
	 * 设置类型
	 * @param type 类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}

	/**
	 * 取得默认值
	 * @return 默认值
	 */
	public String getDefaultValue() {
		return defaultValue;
	}

	/**
	 * 设置默认值
	 * @param defaultValue 默认值
	 */
	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}
	
	/**
	 * 设置查询条件元数据
	 * 
	 * @param condition
	 *            查询条件元数据
	 */
	public void setCondition(MetaCondition condition) {
		this.condition = condition;
	}

	/**
	 * 取得查询条件元数据
	 * 
	 * @return 查询条件元数据
	 */
	public MetaCondition getCondition() {
		return this.condition;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if ( condition != null ) {
			list.add(condition);
		}
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 其它单元格类型创建其它属性定义
	 */
	public void ensureProperties() {
		if ( properties == null ) {
			switch ( this.type ) {
			case ControlType.TEXTAREA:
				this.properties = new MetaTextAreaProperties();
				break;
			case ControlType.LABEL:
				this.properties = new MetaLabelProperties();
				break;
			case ControlType.PRICELABEL:
				this.properties = new MetaPriceLabelProperties();
				break;
			case ControlType.RELATIVETIME:
				this.properties = new MetaRelativeTimeProperties();
				break;
			case ControlType.BUTTON:
				this.properties = new MetaButtonProperties();
				break;
			case ControlType.NOTICEBAR:
				this.properties = new MetaNoticeBarProperties();
				break;
			case ControlType.BARCODER:
				this.properties = new MetaBarCoderProperties();
				break;
			case ControlType.TOGGLEBUTTON:
				this.properties = new MetaToggleButtonProperties();
				break;
			case ControlType.MULTISTATEBUTTON:
				this.properties = new MetaMultiStateButtonProperties();
				break;
			case ControlType.TEXTEDITOR:
				this.properties = new MetaTextEditorProperties();
				break;
			case ControlType.TEXTBUTTON:
				this.properties = new MetaTextButtonProperties();
				break;
			case ControlType.NUMBEREDITOR:
				this.properties = new MetaNumberEditorProperties();
				break;
			case ControlType.CHECKBOX:
				this.properties = new MetaCheckBoxProperties();
				break;
			case ControlType.DICT:
			case ControlType.COMPDICT:
			case ControlType.DYNAMICDICT:
				this.properties = new MetaDictProperties();
				break;
			case ControlType.DATEPICKER:
				this.properties = new MetaDatePickerProperties();
				break;
			case ControlType.UTCDATEPICKER:
				this.properties = new MetaUTCDatePickerProperties();
				break;
			case ControlType.COMBOBOX:
				this.properties = new MetaComboBoxProperties();
				break;
			case ControlType.CHECKLISTBOX:
				this.properties = new MetaCheckListBoxProperties();
				break;
			case ControlType.IMAGE:
				this.properties = new MetaImageProperties();
				break;	
			case ControlType.VIDEOPLAYER:
				this.properties = new MetaVideoPlayerProperties();
				break;				
			case ControlType.HYPERLINK:
				this.properties = new MetaHyperLinkProperties();
				break;
			case ControlType.CUSTOM:
				this.properties = new MetaCustomProperties();
				break;
			case ControlType.DYNAMIC:
				this.properties = new MetaDynamicProperties();
				break;
			case ControlType.MONTHPICKER:
				this.properties = new MetaMonthPickerProperties();
				break;
			case ControlType.TIMEPICKER:
				this.properties = new MetaTimePickerProperties();
				break;
			case ControlType.WIZARDLIST:
				this.properties = new MetaWizardListProperties();
				break;
			}
		}
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( this.properties != null ) {
			resultMetaObject = this.properties.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		
		if (resultMetaObject == null) {
			if (tagName.equals(MetaCondition.TAG_NAME)) {
				condition = new MetaCondition();
				resultMetaObject = condition;
			}
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCellTypeDef cellTypeDef = new MetaCellTypeDef();
		cellTypeDef.setKey(key);
		cellTypeDef.setCaption(caption);
		cellTypeDef.setType(type);
		return cellTypeDef;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCellTypeDef();
	}

	/**
	 * 取得其它属性定义
	 * @return 其它属性定义
	 */
	public AbstractMetaObject getProperties() {
		if( properties == null ) {
			ensureProperties();
		}
		return properties;
	}
	
	/**
	 * 获取属性
	 * @param properties
	 */
	public void setProperties(AbstractMetaObject properties) {
		this.properties = properties;
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		if( properties != null ) {
			properties.doPostProcess(flag, callback);
		}
	}

}
