package com.bokesoft.yigo.meta.form.component.grid;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.RowType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;

/**
 * 定义表格元数据中的所有行，由多个{@link MetaGridRow}组成
 * @author 王元和
 */
public class MetaGridRowCollection extends GenericNoKeyCollection<MetaGridRow> {

	public MetaGridRowCollection() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "GridRowCollection";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject metaObject = null;
		if ( MetaGridRow.TAG_NAME.equals(tagName) ) {
			MetaGridRow metaGridRow = new MetaGridRow();
			metaGridRow.preProcessMetaObject(env, doc, node, flag, runType);
			metaObject = metaGridRow;
			this.add(metaGridRow);
		}
		return metaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaGridRowCollection newObject = (MetaGridRowCollection)super.clone();
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGridRowCollection();
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		int recycleMode = 0;
		for( MetaGridRow metaRow : this ) {
			metaRow.setRecycleMode(recycleMode++);
			
			metaRow.doPostProcess(flag, callback);
			
			switch (metaRow.getRowType()) {
			case RowType.Detail:
				String columnKey = "";
				for( MetaGridCell metaCell : metaRow ){
					columnKey = metaCell.getColumnKey();
					if( columnKey != null && !columnKey.isEmpty() ) {
						metaCell.setHasDataBinding(true);
						metaCell.setTableKey(metaRow.getTableKey());
					}
					metaCell.doPostProcess(flag, callback);
				}
				break;
			case RowType.Fix:
				MetaDataBinding dataBinding = null;
				for( MetaGridCell metaCell : metaRow ){
					dataBinding = metaCell.getDataBinding();
					if( dataBinding != null && dataBinding.hasBinding() ){
						metaCell.setHasDataBinding(true);
						metaCell.setTableKey(dataBinding.getTableKey());
					}
					metaCell.doPostProcess(flag, callback);
				}
				break;
			default:
				break;
			}
		}
	}

}
