package com.bokesoft.yigo.meta.form.component.grid;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.CustomDataType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaCellCustomData extends AbstractMetaObject{
	/** 定制数据类型,默认是*/
	private Integer type = CustomDataType.Expand;
	/** 处理标志*/
	private String tag = "";
	/** 定制类型为Table时,定义表的key*/
	private String tableKey = "";
	
	
	public static final String TAG_NAME = "CellCustomData";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCellCustomData customData = new MetaCellCustomData();
		customData.setTableKey(tableKey);
		customData.setTag(tag);
		customData.setType(type);
		return customData;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCellCustomData();
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	public String getTableKey() {
		return tableKey;
	}

	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}
	
}
