package com.bokesoft.yigo.meta.form.component.control.tableview;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 表视图组件行的配置对象集合
 * @author chenzs
 *
 */
public class MetaTableRowCollection extends GenericNoKeyCollection<MetaTableRow> {

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "TableRowCollection";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaTableRow.TAG_NAME.equals(tagName) ) {
			MetaTableRow row = new MetaTableRow();
			row.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(row);
			resultMetaObject = row;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTableRowCollection();
	}

}
