package com.bokesoft.yigo.meta.form.component.control.shrinkview;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;

public class MetaCollapseView extends AbstractMetaObject {

	public static final String TAG_NAME = "CollapseView";

	/**
	 * 根组件
	 */
	private MetaComponent root;
	
	/**
	 * 默认是否展开
	 */
	private Boolean initExpand = true;

	/**
	 * 获取根组件
	 * @return 根组件
	 */
	public MetaComponent getRoot() {
		return root;
	}

	/**
	 * 设置根组件
	 * @param root 根组件
	 */
	public void setRoot(MetaComponent root) {
		this.root = root;
	}
	
	/**
	 * 获取是否默认展开
	 * @return 是否默认展开
	 */
	public Boolean isInitExpand() {
		return initExpand;
	}
	
	/**
	 * 设置是否默认展开
	 * @param initExpand 是否默认展开
	 */
	public void setInitExpand(Boolean initExpand) {
		this.initExpand = initExpand;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if (root != null)
			list.add(root);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultObj = MetaComponentFactory.getInstance().newComponent(tagName);
		if (resultObj != null) {
			root = (MetaComponent) resultObj;
			root.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return resultObj;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCollapseView meta = (MetaCollapseView) newInstance();
		meta.setInitExpand(initExpand);
		meta.setRoot(root == null ? null : (MetaComponent) root.clone());
		return meta;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCollapseView();
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if (root != null)
			root.doPostProcess(flag, callback);
	}
}
