package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.component.control.wizardlist.MetaWizardItemCollection;
import com.bokesoft.yigo.meta.form.component.control.wizardlist.MetaWizardItemList;

public class MetaWizardListProperties extends AbstractMetaObject implements IPropertyMerger<MetaWizardListProperties>{

	private MetaWizardItemCollection itemCollection;
	private MetaWizardItemList itemList;
	
	/** 文本编辑器为空时的提示信息 */
	private String promptText = "";
	
	/** 编辑样式*/
	private Integer editType = SelectEditType.POP;

	/**
	 * 构造方法，初始化items
	 */
	public MetaWizardListProperties() {
		super();
		itemCollection = new MetaWizardItemCollection();
		itemList = new MetaWizardItemList();
	}
	
	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { itemCollection, itemList });
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaWizardItemCollection.TAG_NAME)) {
			itemCollection = new MetaWizardItemCollection();
			resultMetaObject = itemCollection;
		}else if(tagName.equalsIgnoreCase(MetaWizardItemList.TAG_NAME)){
			itemList = new MetaWizardItemList();
			resultMetaObject = itemList;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaWizardListProperties newObject = new MetaWizardListProperties();
		newObject.setEditType(editType);
		newObject.setPromptText(promptText);
		newObject.setItemCollection(itemCollection==null? null :(MetaWizardItemCollection)itemCollection.clone());
		newObject.setItemList(itemList==null? null :(MetaWizardItemList)itemList.clone());
		return newObject;
	}
	
	public void setItemCollection(MetaWizardItemCollection itemCollection) {
		this.itemCollection = itemCollection;
	}
	
	public MetaWizardItemCollection getItemCollection() {
		return itemCollection;
	}
	
	public void setItemList(MetaWizardItemList itemList) {
		this.itemList = itemList;
	}
	
	public MetaWizardItemList getItemList() {
		return itemList;
	}
	
	public void setPromptText(String promptText) {
		this.promptText = promptText;
	}

	public String getPromptText() {
		return promptText;
	}
	
	public void setEditType(Integer editType) {
		this.editType = editType;
	}
	
	public Integer getEditType() {
		return editType;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaWizardListProperties();
	}

	@Override
	public void merge(MetaWizardListProperties properties) {
		MetaWizardItemCollection itemCollection = properties.getItemCollection();
		if( itemCollection != null ) {
			if( this.itemCollection == null || this.itemCollection.isEmpty() ) {
				this.itemCollection = (MetaWizardItemCollection) itemCollection.clone();
			}			
		}

		MetaWizardItemList itemList = properties.getItemList();
		if( itemList != null ) {
			if( this.itemList == null ) {
				this.itemList = (MetaWizardItemList) itemList.clone();
			}			
		}
		
		if(promptText == null){
			this.promptText = properties.getPromptText();
		}
		
		if(editType == -1){
			this.editType = properties.getEditType();
		}
	}
}
