package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaSliderProperties extends AbstractMetaObject implements IPropertyMerger<MetaSliderProperties>{

	/** 最大值的指示值的默认值 */
	public static final int DEFAULT_MAX_POS = 100;
	
	/** Bar默认颜色默认值 */
	public static final String DEFAULT_BAR_COLOR = "#dddddd";
	
	/** Bar进度颜色默认值 */
	public static final String DEFAULT_PROGRESS_COLOR = "#00aaee";
	
	/** 最大的指示值 */
	private Integer maxPos = DEFAULT_MAX_POS;
	
	/** 最小的指示值 */
	private Integer minPos = 0;
	
	/** 步进值，0或者负数代表没有步进 */
	private Integer stepValue = 0;
	
	/** 滑杆颜色 */
	private String barColor = DEFAULT_BAR_COLOR;
	
	/** 进度颜色 */
	private String progressColor = DEFAULT_PROGRESS_COLOR;
	
	/** 是否允许多选 */
	private Boolean isAllowMultiSelection = false;


	/**
	 * 获取Bar默认颜色
	 * @return Bar默认颜色
	 */
	public String getBarColor() {
		return barColor;
	}

	/**
	 * 设置Bar默认颜色
	 * @param barColor Bar默认颜色
	 */
	public void setBarColor(String barColor) {
		this.barColor = barColor;
	}

	/**
	 * 获取Bar进度颜色
	 * @return Bar进度颜色
	 */
	public String getProgressColor() {
		return progressColor;
	}

	/**
	 * 设置Bar进度颜色
	 * @param progressColor Bar进度颜色
	 */
	public void setProgressColor(String progressColor) {
		this.progressColor = progressColor;
	}
	
	/**
	 * 获取最大指示值
	 * @return 最大指示值
	 */
	public Integer getMaxPos() {
		return maxPos;
	}
	
	/**
	 * 设置最大指示值
	 * @param maxPos 最大指示值
	 */
	public void setMaxPos(Integer maxPos) {
		this.maxPos = maxPos;
	}
	
	/**
	 * 获取最小指示值
	 * @return 最小指示值
	 */
	public Integer getMinPos() {
		return minPos;
	}
	
	/**
	 * 设置最小指示值
	 * @param minPos 最小指示值
	 */
	public void setMinPos(Integer minPos) {
		this.minPos = minPos;
	}
	
	/**
	 * 获取步进值，为0或负数代表没有步进
	 * @return 步进值
	 */
	public Integer getStepValue() {
		return stepValue;
	}

	/**
	 * 设置步进值，为0或负数代表没有步进
	 * @param stepValue 步进值，
	 */
	public void setStepValue(Integer stepValue) {
		this.stepValue = stepValue;
	}

	/** 
	 * 获取是否允许多选
	 * 
	 * @return isAllowMultiSelection 是否允许多选
	 */
	public Boolean isAllowMultiSelection(){
		return isAllowMultiSelection;
	}
	
	/**
	 * 设置是否允许多选
	 * 
	 * @param allowMultiSelection 是否允许多选
	 */
	public void setAllowMultiSelection(Boolean allowMultiSelection) {
		this.isAllowMultiSelection = allowMultiSelection;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}
	
	@Override
	public String getTagName() {
		return null;
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if(maxPos <= minPos){
			throw new MetaException(MetaException.COMPONENT_MAX_NOT_GREATER_THAN_MIN, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ComponentMaxNotGreaterThanMin), ControlType.STR_SLIDER));
		}
		if(stepValue < 0){
			throw new MetaException(MetaException.COMPONENT_STEP_LESS_THAN_ZERO, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ComponentStepLessThanZero), ControlType.STR_SLIDER));
		}else if(stepValue > 0 && ((maxPos - minPos) % stepValue) != 0){
			throw new MetaException(MetaException.COMPONENT_RANGE_CAN_NOT_BE_DIVISIBLE_BY_STEP, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ComponentRangeCannotBeDividedByStep), ControlType.STR_SLIDER));
		}
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaSliderProperties newObj = (MetaSliderProperties)newInstance();
		newObj.setMaxPos(maxPos);
		newObj.setMinPos(minPos);
		newObj.setStepValue(stepValue);
		newObj.setBarColor(barColor);
		newObj.setProgressColor(progressColor);
		newObj.setAllowMultiSelection(isAllowMultiSelection);
		return newObj;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSliderProperties();
	}
	
	@Override
	public void merge(MetaSliderProperties properties) {
		 if(maxPos == null){
			 maxPos = properties.getMaxPos();
		 }
		 if(minPos == null){
			 minPos = properties.getMinPos();
		 }
		 if(stepValue == null){
			 stepValue = properties.getStepValue();
		 }
		 if(barColor == null){
			 barColor = properties.getBarColor();
		 }
		 if(progressColor == null){
			 progressColor = properties.getProgressColor();
		 }
		 if(isAllowMultiSelection == null){
			 isAllowMultiSelection = properties.isAllowMultiSelection();
		 }
	}
}
