package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaStatement;
import com.bokesoft.yigo.meta.dataobject.MetaParameterCollection;

public class MetaQueryDef extends AbstractMetaObject {

	private MetaStatement statement = null;
	
	private MetaParameterCollection parameters = null;
	
	public MetaQueryDef() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { statement, parameters });
	}

	public static final String TAG_NAME = "QueryDef";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	public MetaStatement getStatement(){
		return this.statement;
	}
	
	public void setStatement(MetaStatement statement){
		this.statement = statement;
	}
	
	public boolean isEmpty() {
		return statement == null || (statement.getContent() == null || statement.getContent().isEmpty()); 
	}
	
	public MetaParameterCollection getParameterCollection (){
		return this.parameters;
	}
	
	public void setParameterCollection(MetaParameterCollection parameterCollection){
		this.parameters = parameterCollection;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaStatement.TAG_NAME)) {
			statement = new MetaStatement();
			resultMetaObject = statement;
		} else if (tagName.equalsIgnoreCase(MetaParameterCollection.TAG_NAME)) {
			parameters = new MetaParameterCollection();
			resultMetaObject = parameters;
		}
		
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaQueryDef newObject = (MetaQueryDef)newInstance();
		newObject.setStatement(statement == null ? null : (MetaStatement)statement.clone());
		newObject.setParameterCollection(parameters == null ? null : (MetaParameterCollection)parameters.clone());
		return newObject;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaQueryDef();
	}

	public List<String> getDependedFields(){
		return parameters == null ? Collections.emptyList() :parameters.getDependedFields();
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if( parameters != null )
			this.parameters.doPostProcess(flag, callback);
	}
	
}
