package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaGridDesignerProperties extends AbstractMetaObject {
	private MetaGridDesignerPropCollection propCollection = null;
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(propCollection);
	}

	@Override
	public String getTagName() {
		return null;
	}
	
	/**
	 * 设置自定义属性集合
	 * @param propCollection 属性集合
	 */
	public void setPropCollection(MetaGridDesignerPropCollection propCollection) {
		this.propCollection = propCollection;
	}
	
	/**
	 * 取得自定义属性集合
	 * @return 属性集合
	 */
	public MetaGridDesignerPropCollection getPropCollection() {
		return this.propCollection;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaGridDesignerPropCollection.TAG_NAME.equals(tagName) ) {
			this.propCollection = new MetaGridDesignerPropCollection();
			resultMetaObject = this.propCollection;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaGridDesignerProperties newObject = (MetaGridDesignerProperties)newInstance();
		newObject.setPropCollection(propCollection == null ? null : (MetaGridDesignerPropCollection)propCollection.clone());
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGridDesignerProperties();
	}

}
